function initCropper(ident, width, height, fill) {  
  'use strict';
  var Cropper = window.Cropper;
  
  var URL = window.URL || window.webkitURL;
  var container = document.querySelector(`.img-container-${ident}`);
  var image = container.getElementsByTagName('img').item(0);
  var download = document.getElementById(`download${ident}`);
  var actions = document.getElementById(`actions${ident}`);
  var options = {
    aspectRatio: width  / height,
    preview: '.img-preview',
    ready: function(e) {
    },
    cropstart: function(e) {
    },
    cropmove: function(e) {
    },
    cropend: function(e) {
    },
    crop: function(e) {
      var data = e.detail;
    },
    zoom: function(e) {
    },
    built: function () {
      $toCrop.cropper("setCropBoxData", { width: "width", height: "height" });
    }
  };
  var cropper = new Cropper(image, options);
  var originalImageURL = image.src;
  var uploadedImageType = 'image/jpeg';
  var uploadedImageURL;

  // Buttons
  if (!document.createElement('canvas').getContext) {
    $('button[data-method="getCroppedCanvas"]').prop('disabled', true);
  }

  if (typeof document.createElement('cropper').style.transition === 'undefined') {
    $('button[data-method="rotate"]').prop('disabled', true);
    $('button[data-method="scale"]').prop('disabled', true);
  }

  // Download
  if (typeof download.download === 'undefined') {
    download.className += ' disabled';
  }

  // Options
  actions.querySelector(`#docs-toggles-${ident}`).onchange = function(event) {
    var e = event || window.event;
    var target = e.target || e.srcElement;
    var cropBoxData;
    var canvasData;
    var isCheckbox;
    var isRadio;

    if (!cropper) {
      return;
    }

    if (target.tagName.toLowerCase() === 'label') {
      target = target.querySelector('input');
    }

    isCheckbox = target.type === 'checkbox';
    isRadio = target.type === 'radio';

    if (isCheckbox || isRadio) {
      if (isCheckbox) {
        options[target.name] = target.checked;
        cropBoxData = cropper.getCropBoxData();
        canvasData = cropper.getCanvasData();
        canvasData.height = 100;
        canvasData.width = 100;
        canvasData.naturalHeight = 100;
        canvasData.naturalWidth = 100;

        options.ready = function() {
          cropper.setCropBoxData(cropBoxData).setCanvasData(canvasData);
        };
      } else {
        options[target.name] = target.value;
        options.ready = function() {
        };
      }

      // Restart
      cropper.destroy();
      cropper = new Cropper(image, options);
    }
  };

  // Methods
  actions.querySelector(`.docs-buttons-${ident}`).onclick = function(event) {
    var e = event || window.event;
    var target = e.target || e.srcElement;
    var cropped;
    var result;
    var input;
    var data;

    if (! cropper) {
      return;
    }

    while (target !== this) {
      if (target.getAttribute('data-method')) {
        break;
      }

      target = target.parentNode;
    }

    if (target === this || target.disabled || target.className.indexOf('disabled') > -1) {
      return;
    }

    data = {
      method: target.getAttribute('data-method'),
      target: target.getAttribute('data-target'),
      option: target.getAttribute('data-option') || undefined,
      secondOption: target.getAttribute('data-second-option') || undefined
    };

    cropped = cropper.cropped;

    if (data.method) {
      if (typeof data.target !== 'undefined') {
        input = document.querySelector(data.target);

        if (!target.hasAttribute('data-option') && data.target && input) {
          try {
            data.option = JSON.parse(input.value);
          } catch (e) {
            console.log(e.message);
          }
        }
      }

      switch (data.method) {
        case 'rotate':
          if (cropped) {
            cropper.clear();
          }

          break;

        case 'getCroppedCanvas':
          try {
            data.option = {width: width, height: height};
            console.log(data.option);
          } catch (e) {
            console.log(e.message);
          }

          if (uploadedImageType === 'image/jpeg') {
            if (!data.option) {
              data.option = {};
            }

            data.option.fillColor = fill;
          }

          break;
      }

      result = cropper[data.method](data.option, data.secondOption);

      switch (data.method) {
        case 'rotate':
          if (cropped) {
            cropper.crop();
          }

          break;

        case 'scaleX':
        case 'scaleY':
          target.setAttribute('data-option', -data.option);
          break;



        case 'getCroppedCanvas':
          if (result) {
            $(`#actions${ident}`).addClass('d-none');
            var croppedImage = result.toDataURL(uploadedImageType);

            $('input[name=croppedImage]').val(croppedImage);
            $(`#getCroppedCanvas${ident}`).removeClass('d-none');
            $(`#getCroppedCanvas${ident}`).find('.text-block').html(result);

            if (! download.disabled) {
              download.href = result.toDataURL(uploadedImageType);
            }
          }

          break;

        case 'destroy':
          cropper = null;

          if (uploadedImageURL) {
            URL.revokeObjectURL(uploadedImageURL);
            uploadedImageURL = '';
            image.src = originalImageURL;
          }

          break;
      }

      if (typeof result === 'object' && result !== cropper && input) {
        try {
          input.value = JSON.stringify(result);
        } catch (e) {
          console.log(e.message);
        }
      }
    }
  };

  // Import image
  var inputImage = document.getElementById(`inputImage${ident}`);


  if (URL) {
    inputImage.onchange = function() {
    $(`#getCroppedCanvas${ident}`).addClass('d-none');
    $(`#actions${ident}`).removeClass('d-none');
      var files = this.files;
      var file;

      if (cropper && files && files.length) {
        file = files[0];

            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function(e) {
                $(`.original-image-${ident}`).val(e.target.result);
            };

        if (/^image\/\w+/.test(file.type)) {
          uploadedImageType = file.type;

          if (uploadedImageURL) {
            URL.revokeObjectURL(uploadedImageURL);
          }

          image.src = uploadedImageURL = URL.createObjectURL(file);

          cropper.destroy();
          cropper = new Cropper(image, options);
          inputImage.value = null;
        } else {
          window.alert('Please choose an image or pdf file.');
        }
      }
    };
  } else {
    inputImage.disabled = true;
    inputImage.parentNode.className += ' disabled';
  }
}