<!-- Modal -->
<div class="modal fade dev-modal" id="editVideo{{ $item->id }}" tabindex="-1" role="dialog" aria-labelledby="editVideo{{ $item->id }}Label" aria-hidden="true">
	<div class="modal-dialog modal-gallery-edit" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="editVideo{{ $item->id }}Label">Edit Video</h5>
			</div>
			<form class="media-update" media-id="{{ $item->id }}" modal-id="#editVideo{{ $item->id }}">
				<div class="modal-body">
					<div class="row">
						<div class="col-md-6 pr-4">
							@if( !empty($item->path) )
							<video width="100%" controls poster="{{ Storage::url($item->thumbnail) }}">
							  <source src="{{ Storage::url($item->path) }}" type="video/mp4">
							  Your browser does not support HTML5 video.
							</video>
							@endif
							@if( !empty($item->embedded) )
							    @if( $item->embedded_type=='youtube' )
							     <iframe width="100%" Xwidth="640" height="360" src="https://www.youtube.com/embed/{{ $item->embedded }}" title="YouTube video player" frameborder="0" 
									 allow="accelerometer; XXautoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
							    @elseif( $item->embedded_type=='vimeo' )
								 <iframe src="https://player.vimeo.com/video/{{ $item->embedded }}?color=fef4e7" 
									width="100%" Xwidth="640" height="360" frameborder="0" allow="XXautoplay; fullscreen; picture-in-picture" 
									allowfullscreen></iframe>
								@elseif( $item->embedded_type=='wistia' )

								    <iframe src="https:////fast.wistia.net/embed/iframe/{{ $item->embedded }}" allowtransparency="true" frameborder="0" scrolling="no" class="wistia_embed" name="wistia_embed" allowfullscreen mozallowfullscreen webkitallowfullscreen oallowfullscreen msallowfullscreen width="100%" height="100%"></iframe>
									<script src="https:////fast.wistia.net/assets/external/E-v1.js" async></script>
								   
							  @endif
							@endif
						</div>
						<div class="col-md-6 pl-4">
							<div class="row">
								@php
									$fields = json_decode($item->fields);
								@endphp

		                        @foreach($value['fields'] AS $fieldKey => $field)
		                        <div class="col-md-12 mb-3">
		                            <label class="mb-0">{{ $field['label'] }}</label>
		                            @if(isset($field['description']) && ! empty($field['description']))
		                            <p class="small mb-2 mt-0">{{ $field['description'] }}</p>
		                            @endif

		                            @if($field['type'] == 'textarea')
		                            <textarea name="fields[{{ $fieldKey }}]" class="form-control" required="{{ $field['required'] }}">{{ (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' }}</textarea>

		                            @elseif($field['type'] == 'html')

		                            <textarea name="fields[{{ $fieldKey }}]" class="form-control tiny" required="{{ $field['required'] }}">{!! (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' !!}</textarea>
		                            																
									@else

		                            <input name="fields[{{ $fieldKey }}]" type="{{ $field['type'] }}" class="form-control" value="{{ (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' }}" required="{{ $field['required'] }}">

		                            @endif
	                        	</div>
	                        	@endforeach
								
								<div class='col-md-12 mb-3'>
	                                <label class="d-block mb-0">Thumbnail</label>
									@if(!empty($item->thumbnail))
									<img style="height:10em;width:auto;margin-bottom: 1rem;" src="{{ Storage::url($item->thumbnail) }}" />
									@endif
	                                <p class="small mb-2 mt-0">Still Image to represent the video</p>
	 
	                                <div class="form-group">
				                        <label class="btn btn-secondary btn-block" for="thumbnail{{ $item->id }}">
				                        <input id="thumbnail{{ $item->id }}" name="thumbnail" type="file" class="form-control d-none" />
				                        <input type="hidden" name="width" value="{{ $value['width'] }}">
				                        <span class="docs-tooltip" data-toggle="tooltip{{ $item->id }}">
				                            <span class="fa fa-upload"></span> <span class="banner-upload-copy">Select Your Thumbnail Image</span>
				                        </span>
				                        </label>
				                    </div>
                                </div>

								@if(!empty($item->embedded) or isset($item->embedded_type))
                                <div class='col-md-6 mb-3'>
                                <label class="mb-0">Embedded #ID</label>
                                <p class="small mb-2 mt-0">ID Code for the Video</p>
                                <input name="embedded" type="text" class="form-control" value="{{ $item->embedded }}" />
                                </div>
								
                                <div class='col-md-6 mb-3'>
                                <label class="mb-0">Source</label>
                                <p class="small mb-2 mt-0">Website Link Type</p>
                                    <select name="embedded_type" class="form-control" required="true">
                                        @foreach($value['video_options']['embed'] AS $source)
                                            <option value='{{ $source }}' {{ ($item->embedded_type==$source) ? 'selected' : '' }} }}>{{ ucwords($source) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @endif
                                <div class="col-12 mt-5">
									<button type="submit" class="btn btn-primary">Save changes</button>
                                	<button type="button" class="btn btn-secondary modal-hide modal-closer" data-toggle="modal" data-target="#editVideo{{ $item->id }}" modal-id="#editVideo{{ $item->id }}">Close</button>
                                </div>	
	                    	</div>
						</div>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>