<!-- Modal -->
<div class="modal fade dev-modal" id="editImage{{ $item->id }}" tabindex="-1" role="dialog" aria-labelledby="editImage{{ $item->id }}Label" aria-hidden="true">
	<div class="modal-dialog modal-gallery-edit" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h2 class="modal-title" id="editImage{{ $item->id }}Label">Edit Image</h2>
				<button type="button" class="btn modal-hide close" modal-id="#editImage{{ $item->id }}" data-toggle="modal" data-target="#editImage{{ $item->id }}">
                    <i class="far fa-times-circle"></i>
                </button>
			</div>
 			<div class="row">
 				<div class="col-md-12">
 					<hr class="w-100" style="border: 1px solid #ececec;">
 				</div>
 			</div>
			<form class="media-update" media-id="{{ $item->id }}" modal-id="#editImage{{ $item->id }}">
				<div class="modal-body">
					<div class="row">
						<div class="col-md-12 mb-4">
							<div class="row">
								<div class="col-md-4">
								</div>
								<div class="col-md-4">
									<img src="" data-src="{{ Media::getThumbnail($item->original) }}" class="lazy">
								</div>
							</div>
						</div>
					</div>
					<div class="row mt-2 mb-4">
						<div class="col-sm-6">
							<a class="btn btn-secondary btn-block" href="{{ Storage::url($item->original) }}" download><i class="fas fa-download"></i> Download Original</a>
						</div>
						<div class="col-sm-6">
							<a class="btn btn-secondary btn-block" href="{{ Storage::url($item->path) }}" download><i class="fas fa-download"></i> Download Cropped</a>
						</div>
					</div>
		 			<div class="row">
		 				<div class="col-md-12">
		 					<hr class="w-100" style="border: 1px solid #ececec;">
		 				</div>
		 			</div>
					<div class="row my-3">
						@php
							$fields = json_decode($item->fields);
						@endphp

                        @foreach($value['fields'] AS $fieldKey => $field)
                        <div class="{{ $field['width'] }}">

                            <label>{{ $field['label'] }}</label>

                            @if(isset($field['description']) && ! empty($field['description']))
                            <p class="small m-0">{{ $field['description'] }}</p>
                            @endif

                            @if($field['type'] == 'textarea')
                            <textarea name="fields[{{ $fieldKey }}]" class="form-control" required="{{ $field['required'] }}">{{ (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' }}</textarea>

                            @elseif($field['type'] == 'html')

                            <textarea name="fields[{{ $fieldKey }}]" class="form-control tiny" required="{{ $field['required'] }}">{!! (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' !!}</textarea>
                            @else

                            <input name="fields[{{ $fieldKey }}]" type="{{ $field['type'] }}" class="form-control" value="{{ (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' }}" required="{{ $field['required'] }}">

                            @endif
                        </div>
                        @endforeach
					</div>
					<div class="row">
						<div class="col-md-12">
							@if(isset($value['caption']) && $value['caption']==1)
							<div class="form-group">
								<label>Caption</label>
								<textarea name="caption" class="form-control tiny-bullet">{{ $item->caption }}</textarea>
							</div>
							@endif
						</div>
					</div>
					<div class="row">
		 				<div class="col-md-12">
		 					<hr class="w-100" style="border: 1px solid #ececec;">
		 				</div>
		 			</div>
		 			<div class="row">
		 				<div class="col-md-12 text-right">
							<button type="button" class="btn btn-secondary modal-hide modal-closer" data-toggle="modal" data-target="#editImage{{ $item->id }}" modal-id="#editImage{{ $item->id }}">Close</button>
							<button type="submit" class="btn btn-primary modal-closer"><i class="fas fa-save"></i> Save changes</button>
						</div>
					</div>
				</div>

			</form>
		</div>
	</div>
</div>