@if(in_array($item->extension, Media::videoExtensions()))
    <div class="gallery-img col-sm-12 col-lg-6 col-xl-4 col-xxl-3" media-id="{{ $item->id }}" id="remove-img-{{ $item->id }}">
        <div class="row w-100 h-100 m-0 gallery-border">
            <div class="col-12 p-0 o-hidden">
                <div style="height: 150px; width: 100%; background-size: cover; background-position: center center;">
                @if(!empty($item->thumbnail))
                    <img width="50" height="auto" class="lazy" src="" data-src="{{ Media::getThumbnail($item->original) }}">
                @else
                    @if(!empty($item->embedded))
                        <div style="width:100%;height:150px">
                            <img width="50" height="auto" class="lazy" src="" data-src="{{ Media::getEmbeddedThumbnail($item->embedded, $item->embedded_type) }}">
                        </div>
                    @else
                        <div style="width:100%;height:150px">
                            <img width="50" height="auto" class="lazy" src="" data-src="/images/video_thumbnail.png">
                        </div>
                    @endif
                @endif
                </div>
                <div class="caption h-100">
                        <p>{{ $item->caption }}</p>
                </div>
            </div>
        </div>
        <div class="gallery-img-item">
            <div class="move-btn">
                <span aria-hidden="true"><i class="fas fa-arrows-alt"></i></span>
            </div>
            <div class="delete-btn" data-toggle="modal" data-target="#editVideo{{ $item->id }}">
                <span aria-hidden="true"><i class="fas fa-edit"></i> Edit</span>
            </div>
        </div>
    </div>
    @include('media-manager::partials.media-video-update')
@elseif(in_array($item->extension, Media::audioExtensions()))
    <div class="gallery-img col-sm-12 col-lg-6 col-xl-4 col-xxl-3" media-id="{{ $item->id }}" id="remove-img-{{ $item->id }}">
        <img width="50" height="auto" class="lazy" src="" data-src="/images/audio_thumbnail.jpg">
        <div class="gallery-img-item">
            <div class="move-btn">
                <span aria-hidden="true"><i class="fas fa-arrows-alt"></i></span>
            </div>
            <div class="delete-btn" data-toggle="modal" data-target="#editAudio{{ $item->id }}">
                <span aria-hidden="true"><i class="fas fa-edit"></i> Edit</span>
            </div>
        </div>

    </div>
    @include('media-manager::partials.media-audio-update')

@else
    <div class="gallery-img col-sm-12 col-lg-6 col-xl-4 col-xxl-3" media-id="{{ $item->id }}" id="remove-img-{{ $item->id }}">
        <img width="50" height="auto" class="lazy" src="" data-src="{{ Media::getThumbnail($item->original) }}">
        <div class="gallery-img-item">
            <div class="move-btn">
                <span aria-hidden="true"><i class="fas fa-arrows-alt"></i></span>
            </div>
            <div class="delete-btn" data-toggle="modal" data-target="#editImage{{ $item->id }}">
                <span aria-hidden="true"><i class="fas fa-edit"></i> Edit</span>
            </div>
        </div>

    </div>
    @include('media-manager::partials.media-update')
@endif
