<div class="modal fade dev-modal-inner" id="uploadModal{{ $value['ident'] }}" tabindex="-1" role="dialog" aria-labelledby="uploadModal{{ $value['ident'] }}Label" aria-hidden="true" media-modal="{{ $value['ident'] }}">
    <div class="modal-dialog modal-media text-left" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h2>Upload Image</h2>
                <button type="button" class="uploadModalClose close" data-toggle="modal" data-target="#uploadModal{{ $value['ident'] }}" aria-label="Close">
                    <i class="far fa-times-circle"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-12">
                        <form class="mediaUpload" media-ident="{{ $value['ident'] }}" media-category="{{ $key }}">
                            <input type="hidden" name="type" value="{{ $table }}">
                            <input type="hidden" name="key" value="{{ $foreignKey }}">
                            <input type="hidden" name="ident" value="{{ $value['ident'] }}">
                            <input type="hidden" name="category" value="{{ $key }}">
                            <div class="row">
                                <div class="col-md-12">
                                    @include('media-manager::partials.cropper-upload')
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="stage">Stage&nbsp;</div><span class="stage-number">2</span>
                                    <hr class="modal-divide">
                                </div>
                                @foreach($value['fields'] AS $fieldKey => $field)
                                <div class="{{ $field['width'] }}">
                                    <label>{{ $field['label'] }}</label>
                                    @if(isset($field['description']) && ! empty($field['description']))
                                    <p class="small m-0">{{ $field['description'] }}</p>
                                    @endif
                                    @if($field['type'] == 'textarea')
                                    <textarea name="fields[{{ $fieldKey }}]" class="form-control" required="{{ $field['required'] }}"></textarea>
                                    @elseif($field['type'] == 'html')
                                    <textarea name="fields[{{ $fieldKey }}]" class="form-control tiny" required="{{ $field['required'] }}"></textarea>
                                    @else
                                    <input name="fields[{{ $fieldKey }}]" type="{{ $field['type'] }}" class="form-control" required="{{ $field['required'] }}">
                                    @endif
                                </div>
                                @endforeach
                            </div>
                            <div class="row mt-5">
                                <div class="col-md-12">
                                    <div class="row">
                                        <input type="hidden" name="croppedImage" class="form-control cropped-image-{{ $value['ident'] }}" required>
                                        <input type="hidden" name="originalImage" class="form-control original-image-{{ $value['ident'] }}" required>
                                        <div class="col-6">
                                            <button type="submit" class="btn btn-primary full-width"> <i class="far fa-image"></i> Upload and add another </button>
                                        </div>
                                        <div class="col-6">
                                            <button type="submit" class="btn btn-primary full-width" data-toggle="modal" data-target="#uploadModal{{ $value['ident'] }}"> <i class="far fa-image"></i> Upload and close </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>