<div class="modal-body-lg h-100">
    <div class="row no-gutters h-100">
        <div class="col-sm-8 h-100 scroll-overflow">
            <div class="media-manager-left">
                <div id="saveSuccess" class="saveSuccess d-none" role="alert">
                    <div class="circle-loader">
                      <div class="checkmark draw"></div>
                    </div>
                      <div class="saved d-none">{!! $key !!} Imagery Saved</div>
                </div>
                <div class="row bg-white border-standard p-5 align-items-center">
                    <div class="col-sm-12">
                        <h4>{!! $key !!}</h4>
                    </div>
                    <div class="col-sm-9 text-left">
                        @if($value['image'])
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#uploadModal{{ $value['ident'] }}">
                            Upload Image <i class="far fa-image m-1"></i>
                        </button>
                        @include('media-manager::partials.media-image')
                        @endif
                        @if($value['video'])
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#uploadVideo{{ $value['ident'] }}">
                             Upload Video <i class="fas fa-video m-1"></i>
                        </button>
                        @include('media-manager::partials.media-video')
                        @endif
                        @if(isset($value['video_options']['embed']) and count($value['video_options']['embed'])>0)
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#embedVideo{{ $value['ident'] }}">
                             Embed a Video <i class="fas fa-video m-1"></i>
                        </button>
                        @include('media-manager::partials.media-embed')
                        @endif
                    </div>
                    <div class="col-sm-3 text-right">
                        <button type="button" class="mediaSave float-right btn btn-secondary media-save"><i class="fas fa-save"></i> Save Gallery
                        </button>
                    </div>
                    <div class="col-sm-12 py-3">
                        <hr>
                    </div>
                    <div class="col-sm-12">
                        <div class="row gallery-img-lg media-gallery" uk-sortable="group: sortable-group" media-type="{{ $table }}" media-category="{{ $key }}" media-key="{{ $foreignKey }}" media-ident="{{ $value['ident'] }}" media-refresh="{{ $value['ident'] }}" media-group="{{ (! empty($foreignKey)) ? Media::getGroupOrNull($table, $foreignKey, $value['ident']) : '' }}">
                            @foreach(Media::getMedia(null, $table, $foreignKey, $value['ident']) AS $item)
                            @include('media-manager::partials.media-item')
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-sm-4">
            <div class="row">
                <div class="col-12 trash-area">
                    <div class="trash"><i class="fas fa-trash-alt"></i></div>
                    <div class="scroll-overflow h-100">
                        <div class="media-manager-right h-100">
                            <h4 class="latest-title">Remove Media</h4>
                            <div class="row no-gutters target-area p-0" uk-sortable="group: sortable-group"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row no-gutters">
        <div class="col-sm-8">
            <div class="media-manager-footer">
                <button class="btn btn-close" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="far fa-times-circle"></i> Close
                </button>
            </div>
        </div>
    </div>
</div>

