<div class="modal fade dev-modal-inner" id="embedVideo{{ $value['ident'] }}" tabindex="-1" role="dialog" aria-labelledby="embedVideo{{ $value['ident'] }}Label" aria-hidden="true" media-modal="{{ $value['ident'] }}">
    <div class="modal-dialog modal-media" role="document">
        <div class="modal-content">
            <div class="modal-body">
                 <button type="button" class="uploadModalClose close" data-toggle="modal" data-target="#embedVideo{{ $value['ident'] }}" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
                <div class="row align-items-center text-left">
                    <div class="col-6">
                        <h2 class="mt-4">Add an Embedded Video Link</h2>
                    </div>
                </div>
                <form class="videoUpload" media-ident="{{ $value['ident'] }}">
                    <input type="hidden" name="type" value="{{ $table }}">
                    <input type="hidden" name="key" value="{{ $foreignKey }}">
                    <input type="hidden" name="ident" value="{{ $value['ident'] }}">
                    <input type="hidden" name="category" value="{{ $key }}">
                    
                    <div class="col-12">
                        <div class="row">
                            @foreach($value['fields'] AS $fieldKey => $field)
                                @if(!isset($field['upload']) or $field['upload'])
                                <div class="{{ $field['width'] }}">
                                    <label>{{ $field['label'] }}</label>
                                    @if(isset($field['description']) && ! empty($field['description']))
                                    <p class="small m-0">{{ $field['description'] }}</p>
                                    @endif
                                    @if($field['type'] == 'textarea')
                                    <textarea name="fields[{{ $fieldKey }}]" class="form-control" required="{{ $field['required'] }}"></textarea>
                                    @elseif($field['type'] == 'html')
                                    <textarea name="fields[{{ $fieldKey }}]" class="form-control tiny" required="{{ $field['required'] }}"></textarea>
                                    @else
                                    <input name="fields[{{ $fieldKey }}]" type="{{ $field['type'] }}" class="form-control" required="{{ $field['required'] }}">
                                    @endif
                                </div>
                                @endif
                            @endforeach

                            <div class='col-md-3'>
                            <label>Thumbnail</label>
                            <p class="small m-0">Still Image to represent the video</p>
                            <input name="thumbnail" type="file" class="form-control" />
                            </div>

                            @if(isset($value['video_options']['embed']))
                            <div class='col-md-3'>
                            <label>Source</label>
                            <p class="small m-0">Website Link Type</p>
                                <select name="embedded_type" class="form-control" required="true">
                                    @foreach($value['video_options']['embed'] AS $source)
                                        <option value='{{ $source }}'>{{ ucwords($source) }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif

                            <div class='col-md-3'>
                            <label>Embedded #ID</label>
                            <p class="small m-0">ID Code for the Video</p>
                            <input name="embedded" type="text" class="form-control" />
                            </div>
                            
                        </div>
                    </div>
                    <div class="row text-left">
                        <div class="col-6">
                            <button type="submit" class="btn btn-primary"><i class="fas fa-video"></i> Save The Embedded Media Link</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
