<!-- Modal -->
<div class="modal fade dev-modal" id="editVideo{{ $item->id }}" tabindex="-1" role="dialog" aria-labelledby="editVideo{{ $item->id }}Label" aria-hidden="true">
	<div class="modal-dialog modal-gallery-edit" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="editVideo{{ $item->id }}Label">Edit Video</h5>
			</div>
			<form class="media-update" media-id="{{ $item->id }}" modal-id="#editVideo{{ $item->id }}">
				<div class="modal-body">
					<div class="row">
						<div class="col-md-12">
							<video width="100%" controls>
							  <source src="{{ Storage::url($item->path) }}" type="video/mp4">
							  Your browser does not support HTML5 video.
							</video>
						</div>
						<div class="col-md-12">
							<div class="row">
								@php
									$fields = json_decode($item->fields);
								@endphp

		                        @foreach($value['fields'] AS $fieldKey => $field)
		                        <div class="{{ $field['width'] }}">

		                            <label>{{ $field['label'] }}</label>

		                            @if(isset($field['description']) && ! empty($field['description']))
		                            <p class="small m-0">{{ $field['description'] }}</p>
		                            @endif

		                            @if($field['type'] == 'textarea')
		                            <textarea name="fields[{{ $fieldKey }}]" class="form-control" required="{{ $field['required'] }}">{{ (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' }}</textarea>

		                            @elseif($field['type'] == 'html')

		                            <textarea name="fields[{{ $fieldKey }}]" class="form-control tiny" required="{{ $field['required'] }}">{!! (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' !!}</textarea>
		                            @else

		                            <input name="fields[{{ $fieldKey }}]" type="{{ $field['type'] }}" class="form-control" value="{{ (isset($fields->{$fieldKey})) ? $fields->{$fieldKey} : '' }}" required="{{ $field['required'] }}">

		                            @endif
	                        	</div>
	                        	@endforeach
	                    	</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary modal-hide modal-closer" data-toggle="modal" data-target="#editVideo{{ $item->id }}" modal-id="#editVideo{{ $item->id }}">Close</button>
					<button type="submit" class="btn btn-primary">Save changes</button>
				</div>
			</form>
		</div>
	</div>
</div>