<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMediaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('media', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('category')->nullable();
            $table->text('tags')->nullable();
            $table->string('type')->nullable();
            $table->integer('key')->nullable();
            $table->integer('group')->nullable();
            $table->string('ident')->nullable();
            $table->string('alt')->nullable();
            $table->text('caption')->nullable();
            $table->boolean('list')->default(0);
            $table->string('path');
            $table->string('original')->nullable();
            $table->decimal('aspect',8,2)->nullable();
            $table->string('header')->nullable();
            $table->text('sub_header')->nullable();
            $table->string('header_link')->nullable();
            $table->text('header_link_text')->nullable();
            $table->text('filename')->nullable();
            $table->string('extension')->nullable();
            $table->integer('order')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('media');
    }
}