// Keep tab active
$(document).ready(function(){
  $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {
    localStorage.setItem('activeTab', $(e.target).attr('href'));
  });
  var activeTab = localStorage.getItem('activeTab');
  if(activeTab){
    $('#tabs-tab a[href="' + activeTab + '"]').tab('show');
  }
});

// Upload video
$('body').on('submit', '.videoUpload', function(e){
  e.preventDefault();
  var data = new FormData($(this)[0]);
  var ident = $(this).attr('media-ident');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: '/ajax/media/video/upload',
    type: 'post',
    data: data,
    cache: false,
    contentType: false,
    processData: false,
    success: function (group) {
    $('[media-ident='+ident+']').attr('media-group', group);
    var category = $('[media-ident='+ident+']').attr('media-category');
    refreshMedia(group, category, ident);
    $('.videoUpload').trigger('reset');
    $('.canvas-preview').empty();
    }
  });
});

// Image upload
$('body').on('submit', '.mediaUpload', function(e){
  e.preventDefault();
  var data = $(this).serialize();
  var ident = $(this).attr('media-ident');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
  url: '/ajax/media/upload',
  type: 'post',
  data: data,
  success: function(group){
    $('[media-ident='+ident+']').attr('media-group', group);
    var category = $('[media-ident='+ident+']').attr('media-category');
    refreshMedia(group, category, ident);
    $('.mediaUpload').trigger('reset');
    $('.canvas-preview').empty();
  }
  });
});

// Update
$('body').on('submit', '.media-update', function(e){
  e.preventDefault();
  var data = $(this).serialize();
  var target = $(this).attr('modal-id');
  var id = $(this).attr('media-id');
  var category = $(this).attr('media-category');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
  url: '/ajax/media/update/'+id,
  type: 'post',
  data: data,
  success: function(){
    $(target).modal('hide');
  }
  });
});

// Not functional yet
$('body').on('change', '[media-filter]', function(){
  var type = $(this).attr('media-filter');
  var value = $(this).val();

  $.ajax({
  url: '/ajax/media/filter/'+type+'/'+value,
  type: 'get',
  success: function(html){
    var title = $(html).filter('.new-latest-title').html();

    $('.latest-title').each(function(){
        $(this).html(title);
    });

    $('.filter-results').each(function(){
        $(this).html(html);
    });
  }
  })
});



$('body').on('click', '.media-save', function(e){
    e.preventDefault();
    var create = $('[create-form]');

    if(typeof(create) != "undefined" && create !== null) {
      createReOrder();
    } else{
      reOrder();
    }
});

function refreshMedia(group, category , ident){
    $.ajax({
        type: 'get',
        url: '/ajax/media/refresh-group/'+group+'/'+category+'/'+ident,
        success: function(html){

            $('<input type="hidden" name="group" value="'+group+'">').appendTo('form[media-ident='+ident+']');
            var length = $('form[create-form] input[name=groups]').length;

            if(length==0){
                $('<input type="hidden" name="groups" value="'+group+'">').appendTo('form[create-form]');
            } else {
                var groups = $('form[create-form] input[name=groups]').val();
                $('form[create-form] input[name=groups]').val(groups+','+group);
            }

            $('.media-gallery[media-group='+group+']').html(html);
            $('.media-gallery[media-group='+group+']').attr('media-group', group);

            reOrder();
        }
    });
}

function createReOrder()
{    
    var groups = {};
    var i = 0;

    $('.media-gallery').each(function(){
    groups[i] = {};
    groups[i]['media'] = {};
    var x = 0;

    var type = $(this).attr('media-type');
    var key = $(this).attr('media-key');
    var ident = $(this).attr('media-ident');
    var category = $(this).attr('media-category');
    var group = $(this).attr('media-group');

    groups[i]['type'] = type;
    groups[i]['key'] = key;
    groups[i]['ident'] = ident;
    groups[i]['category'] = category;
    groups[i]['group'] = group;

    $(this).find('.gallery-img').each(function(){
      groups[i]['media'][x] = $(this).attr('media-id');
      x++;
    });

    i++;
  });


  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: '/ajax/media/reorder',
    type: 'post',
    data: {'data' : groups},
    success: function(html){

      $('.saveSuccess').removeClass('d-none');
      $('.saveSuccess').addClass('d-block');

      window.setTimeout(function(){
        $('.circle-loader').addClass("load-complete");
        $('.checkmark').toggle();
        $('.saved').removeClass('d-none');
      }, 500) ; //<-- Delay in milliseconds

      window.setTimeout(function(){
        $('.saveSuccess').removeClass('d-block').addClass('d-none');
         $('.checkmark').toggle();
      }, 1200); //<-- Delay in milliseconds

      var group = $(html).filter('input[name=group]').val();
      var length = $('form[create-form] input[name=groups]').length;

      if(length==0){
          $('<input type="hidden" name="groups" value="'+group+'">').appendTo('form[create-form]');
      } else {
          var groups = $('form[create-form] input[name=groups]').val();
          $('form[create-form] input[name=groups]').val(groups+','+group);
      }

      $('.media-gallery[media-group='+group+']').html(html);
      $('.media-gallery[media-group='+group+']').attr('media-group', group);

      reOrder();
    }

  });

}

function reOrder(){    
    var groups = {};
    var i = 0;

    $('.media-gallery').each(function(){
      groups[i] = {};
      groups[i]['media'] = {};
      var x = 0;


      var type = $(this).attr('media-type');
      var key = $(this).attr('media-key');
      var ident = $(this).attr('media-ident');
      var category = $(this).attr('media-category');
      var group = $(this).attr('media-group');

      groups[i]['type'] = type;
      groups[i]['key'] = key;
      groups[i]['ident'] = ident;
      groups[i]['category'] = category;
      groups[i]['group'] = group;

      $(this).find('.gallery-img').each(function(){
        groups[i]['media'][x] = $(this).attr('media-id');
        x++;
      });

        i++;
    });

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: '/ajax/media/reorder',
    type: 'post',
    data: {'data' : groups},
    success: function(html){
      $('.saveSuccess').removeClass('d-none');
      $('.saveSuccess').addClass('d-block');

      window.setTimeout(function(){
        $('.circle-loader').addClass("load-complete");
        $('.checkmark').toggle();
        $('.saved').removeClass('d-none');
      }, 500) ; //<-- Delay in milliseconds

      window.setTimeout(function(){
        $('.saveSuccess').removeClass('d-block').addClass('d-none');
         $('.checkmark').toggle();
      }, 1200); //<-- Delay in milliseconds
    }
  });
}
