<?php

namespace Clevercherry\MediaManager;

use Illuminate\Support\ServiceProvider;

class MediaManagerProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->publishes([
            __DIR__.'/views' => resource_path('views/vendor/media-manager'),
            __DIR__.'/js' => base_path('public/js/clevercherry/media-manager'),
            __DIR__.'/css' => base_path('public/css/clevercherry/media-manager'),
            __DIR__.'/images' => base_path('public/images'),
            __DIR__.'/config/media.php' => config_path('media.php'),
        ], 'media');
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app->make('Clevercherry\MediaManager\Controllers\MediaController');
        $this->loadRoutesFrom(__DIR__.'/routes.php');
        $this->loadMigrationsFrom(__DIR__.'/migrations');
        $this->loadViewsFrom(__DIR__.'/views', 'media-manager');
    }
}
