<script>

  'use strict';

  var Cropper{{ $value['ident'] }} = window.Cropper;
  
  var URL{{ $value['ident'] }} = window.URL || window.webkitURL;
  var container{{ $value['ident'] }} = document.querySelector('.img-container-{{ $value['ident'] }}');
  var image{{ $value['ident'] }} = container{{ $value['ident'] }}.getElementsByTagName('img').item(0);
  var download{{ $value['ident'] }} = document.getElementById('download{{ $value['ident'] }}');
  var actions{{ $value['ident'] }} = document.getElementById('actions{{ $value['ident'] }}');
  var options{{ $value['ident'] }} = {
    aspectRatio: {{ $value['width'] }} / {{ $value['height'] }},
    preview: '.img-preview',
    ready: function(e) {
    },
    cropstart: function(e) {
    },
    cropmove: function(e) {
    },
    cropend: function(e) {
    },
    crop: function(e) {
      var data = e.detail;
    },
    zoom: function(e) {
    },
    built: function () {
      $toCrop.cropper("setCropBoxData", { width: "{{ $value['width'] }}", height: "{{ $value['height'] }}" });
    }
  };
  var cropper{{ $value['ident'] }} = new Cropper{{ $value['ident'] }}(image{{ $value['ident'] }}, options{{ $value['ident'] }});
  var originalImageURL = image{{ $value['ident'] }}.src;
  var uploadedImageType = 'image/jpeg';
  var uploadedImageURL;

  // Buttons
  if (!document.createElement('canvas').getContext) {
    $('button[data-method="getCroppedCanvas"]').prop('disabled', true);
  }

  if (typeof document.createElement('cropper').style.transition === 'undefined') {
    $('button[data-method="rotate"]').prop('disabled', true);
    $('button[data-method="scale"]').prop('disabled', true);
  }

  // Download
  if (typeof download{{ $value['ident'] }}.download === 'undefined') {
    download{{ $value['ident'] }}.className += ' disabled';
  }

  // Options
  actions{{ $value['ident'] }}.querySelector('#docs-toggles-{{ $value['ident'] }}').onchange = function(event) {
    var e = event || window.event;
    var target = e.target || e.srcElement;
    var cropBoxData;
    var canvasData;
    var isCheckbox;
    var isRadio;

    if (!cropper{{ $value['ident'] }}) {
      return;
    }

    if (target.tagName.toLowerCase() === 'label') {
      target = target.querySelector('input');
    }

    isCheckbox = target.type === 'checkbox';
    isRadio = target.type === 'radio';

    if (isCheckbox || isRadio) {
      if (isCheckbox) {
        options{{ $value['ident'] }}[target.name] = target.checked;
        cropBoxData = cropper{{ $value['ident'] }}.getCropBoxData();
        canvasData = cropper{{ $value['ident'] }}.getCanvasData();
        canvasData.height = 100;
        canvasData.width = 100;
        canvasData.naturalHeight = 100;
        canvasData.naturalWidth = 100;

        options{{ $value['ident'] }}.ready = function() {
          cropper{{ $value['ident'] }}.setCropBoxData(cropBoxData).setCanvasData(canvasData);
        };
      } else {
        options{{ $value['ident'] }}[target.name] = target.value;
        options{{ $value['ident'] }}.ready = function() {
        };
      }

      // Restart
      cropper{{ $value['ident'] }}.destroy();
      cropper{{ $value['ident'] }} = new Cropper{{ $value['ident'] }}(image{{ $value['ident'] }}, options{{ $value['ident'] }});
    }
  };

  // Methods
  actions{{ $value['ident'] }}.querySelector('.docs-buttons-{{ $value['ident'] }}').onclick = function(event) {
    var e = event || window.event;
    var target = e.target || e.srcElement;
    var cropped;
    var result;
    var input;
    var data;

    if (!cropper{{ $value['ident'] }}) {
      return;
    }

    while (target !== this) {
      if (target.getAttribute('data-method')) {
        break;
      }

      target = target.parentNode;
    }

    if (target === this || target.disabled || target.className.indexOf('disabled') > -1) {
      return;
    }

    data = {
      method: target.getAttribute('data-method'),
      target: target.getAttribute('data-target'),
      option: target.getAttribute('data-option') || undefined,
      secondOption: target.getAttribute('data-second-option') || undefined
    };

    cropped = cropper{{ $value['ident'] }}.cropped;

    if (data.method) {
      if (typeof data.target !== 'undefined') {
        input = document.querySelector(data.target);

        if (!target.hasAttribute('data-option') && data.target && input) {
          try {
            data.option = JSON.parse(input.value);
          } catch (e) {
            console.log(e.message);
          }
        }
      }

      switch (data.method) {
        case 'rotate':
          if (cropped) {
            cropper{{ $value['ident'] }}.clear();
          }

          break;

        case 'getCroppedCanvas':
          try {
            data.option = {width: {{ $value['width'] }}, height: {{ $value['height'] }}};
            console.log(data.option);
          } catch (e) {
            console.log(e.message);
          }

          if (uploadedImageType === 'image/jpeg') {
            if (!data.option) {
              data.option = {};
            }

            data.option.fillColor = '{{ (! empty($value['fill'])) ? $value['fill'] : '#fff' }}';
          }

          break;
      }

      result = cropper{{ $value['ident'] }}[data.method](data.option, data.secondOption);

      switch (data.method) {
        case 'rotate':
          if (cropped) {
            cropper{{ $value['ident'] }}.crop();
          }

          break;

        case 'scaleX':
        case 'scaleY':
          target.setAttribute('data-option', -data.option);
          break;



        case 'getCroppedCanvas':
          if (result) {
            $('#actions{{ $value['ident'] }}').addClass('d-none');
            var croppedImage = result.toDataURL(uploadedImageType);

            $('input[name=croppedImage]').val(croppedImage);
            $('#getCroppedCanvas{{ $value['ident'] }}').removeClass('d-none');
            $('#getCroppedCanvas{{ $value['ident'] }}').find('.text-block').html(result);

            if (!download{{ $value['ident'] }}.disabled) {
              download{{ $value['ident'] }}.href = result.toDataURL(uploadedImageType);
            }
          }

          break;

        case 'destroy':
          cropper{{ $value['ident'] }} = null;

          if (uploadedImageURL) {
            URL{{ $value['ident'] }}.revokeObjectURL(uploadedImageURL);
            uploadedImageURL = '';
            image{{ $value['ident'] }}.src = originalImageURL;
          }

          break;
      }

      if (typeof result === 'object' && result !== cropper{{ $value['ident'] }} && input) {
        try {
          input.value = JSON.stringify(result);
        } catch (e) {
          console.log(e.message);
        }
      }
    }
  };

  // Import image
  var inputImage{{ $value['ident'] }} = document.getElementById('inputImage{{ $value['ident'] }}');


  if (URL) {
    inputImage{{ $value['ident'] }}.onchange = function() {
    $('#getCroppedCanvas{{ $value['ident'] }}').addClass('d-none');
    $('#actions{{ $value['ident'] }}').removeClass('d-none');
      var files = this.files;
      var file;

      if (cropper{{ $value['ident'] }} && files && files.length) {
        file = files[0];

            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function(e) {
                $('.original-image-{{ $value['ident'] }}').val(e.target.result);
            };

        if (/^image\/\w+/.test(file.type)) {
          uploadedImageType = file.type;

          if (uploadedImageURL) {
            URL{{ $value['ident'] }}.revokeObjectURL(uploadedImageURL);
          }

          image{{ $value['ident'] }}.src = uploadedImageURL = URL{{ $value['ident'] }}.createObjectURL(file);

          cropper{{ $value['ident'] }}.destroy();
          cropper{{ $value['ident'] }} = new Cropper{{ $value['ident'] }}(image{{ $value['ident'] }}, options{{ $value['ident'] }});
          inputImage{{ $value['ident'] }}.value = null;
        } else {
          window.alert('Please choose an image or pdf file.');
        }
      }
    };
  } else {
    inputImage{{ $value['ident'] }}.disabled = true;
    inputImage{{ $value['ident'] }}.parentNode.className += ' disabled';
  }
</script>
