// Keep tab active
$(document).ready(function(){
  $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {
    localStorage.setItem('activeTab', $(e.target).attr('href'));
  });
  var activeTab = localStorage.getItem('activeTab');
  if(activeTab){
    $('#tabs-tab a[href="' + activeTab + '"]').tab('show');
  }
});

// Upload video
$('body').on('submit', '.videoUpload', function(e){
  e.preventDefault();
  var data = new FormData($(this)[0]);
  var ident = $(this).attr('media-ident');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: '/ajax/media/video/upload',
    type: 'post',
    data: data,
    cache: false,
    contentType: false,
    processData: false,
    success: function (html) {
      $('[media-refresh="'+ident+'"]').html(html);
      $('.videoUpload').trigger('reset');
      $('.canvas-preview').empty();
      var group = $('input[name=group]').val();
      $('<input type="hidden" name="group" value="'+group+'">').appendTo('form');
    }
  });
});

// Image upload
$('body').on('submit', '.mediaUpload', function(e){
  e.preventDefault();
  var data = $(this).serialize();
  var ident = $(this).attr('media-ident');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
  url: '/ajax/media/upload',
  type: 'post',
  data: data,
  success: function(html){
    $('[media-refresh="'+ident+'"]').html(html);
    $('.mediaUpload').trigger('reset');
    $('.canvas-preview').empty();
    var group = $('input[name=group]').val();
    $('<input type="hidden" name="group" value="'+group+'">').appendTo('form');
  }
  });
});

// Update
$('body').on('submit', '.media-update', function(e){
  e.preventDefault();
  var data = $(this).serialize();
  var target = $(this).attr('modal-id');
  var id = $(this).attr('media-id');
  var category = $(this).attr('media-category');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
  url: '/ajax/media/update/'+id,
  type: 'post',
  data: data,
  success: function(){
    $(target).modal('hide');
  }
  });
});

// Not functional yet
$('body').on('change', '[media-filter]', function(){
  var type = $(this).attr('media-filter');
  var value = $(this).val();

  $.ajax({
  url: '/ajax/media/filter/'+type+'/'+value,
  type: 'get',
  success: function(html){
    var title = $(html).filter('.new-latest-title').html();

    $('.latest-title').each(function(){
    $(this).html(title);
    });

    $('.filter-results').each(function(){
    $(this).html(html);
    });
  }
  })
});

$('body').on('click', '.media-save', function(e){
    e.preventDefault();

    var groups = {};
  var i = 0;

    $('.media-gallery').each(function(){
    groups[i] = {};
    groups[i]['media'] = {};
    var x = 0;

    var type = $(this).attr('media-type');
    var key = $(this).attr('media-key');
    var ident = $(this).attr('media-ident');
    var category = $(this).attr('media-category');

    groups[i]['type'] = type;
    groups[i]['key'] = key;
    groups[i]['ident'] = ident;
    groups[i]['category'] = category;

    $(this).find('.gallery-img').each(function(){
      groups[i]['media'][x] = $(this).attr('media-id');
      x++;
    });

    i++;
  });

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: '/ajax/media/reorder',
    type: 'post',
    data: {'data' : groups},
    success: function(html){

      $('.saveSuccess').removeClass('d-none');
      $('.saveSuccess').addClass('d-block');

      window.setTimeout(function(){
        $('.circle-loader').addClass("load-complete");
        $('.checkmark').toggle();
        $('.saved').removeClass('d-none');
      }, 500) ; //<-- Delay in milliseconds

      window.setTimeout(function(){
        $('.saveSuccess').removeClass('d-block').addClass('d-none');
         $('.checkmark').toggle();
      }, 1200); //<-- Delay in milliseconds

      var group = $('input[name=group]').val();
      $('<input type="hidden" name="group" value="'+group+'">').appendTo('form');
    }
  });
});
