// Keep tab active
$(document).ready(function(){
  $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {
    localStorage.setItem('activeTab', $(e.target).attr('href'));
  });
  var activeTab = localStorage.getItem('activeTab');
  if(activeTab){
    $('#tabs-tab a[href="' + activeTab + '"]').tab('show');
  }
});

// Upload video
$('body').on('submit', '.videoUpload', function(e){
  e.preventDefault();
  var data = new FormData($(this)[0]);
  var ident = $(this).attr('media-ident');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: '/ajax/media/video/upload',
    type: 'post',
    data: data,
    cache: false,
    contentType: false,
    processData: false,
    success: function (html) {
      $('[media-refresh="'+ident+'"]').html(html);
      $('[media-modal="'+ident+'"]').hide();
      $('.videoUpload').trigger('reset');
    }
  });
});

// Image upload
$('body').on('submit', '.mediaUpload', function(e){
  e.preventDefault();
  var data = $(this).serialize();
  var ident = $(this).attr('media-ident');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
  url: '/ajax/media/upload',
  type: 'post',
  data: data,
  success: function(html){
    $('[media-refresh="'+ident+'"]').html(html);
    $('[media-modal="'+ident+'"]').hide();
    $('.mediaUpload').trigger('reset');
  }
  });
});

// Update
$('body').on('submit', '.media-update', function(e){
  e.preventDefault();
  var data = $(this).serialize();
  var target = $(this).attr('modal-id');
  var id = $(this).attr('media-id');
  var category = $(this).attr('media-category');

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
  url: '/ajax/media/update/'+id,
  type: 'post',
  data: data,
  success: function(){
    $(target).modal('hide');
  }
  });
});

// Not functional yet
$('body').on('change', '[media-filter]', function(){
  var type = $(this).attr('media-filter');
  var value = $(this).val();

  $.ajax({
  url: '/ajax/media/filter/'+type+'/'+value,
  type: 'get',
  success: function(html){
    var title = $(html).filter('.new-latest-title').html();

    $('.latest-title').each(function(){
    $(this).html(title);
    });

    $('.filter-results').each(function(){
    $(this).html(html);
    });
  }
  })
});

$('body').on('click', '.media-save', function(e){
    e.preventDefault();
    var time = 200;

  $('.media-gallery').each(function(){
  var data = {};
  var i = 0;

  var type = $(this).attr('media-type');
  var key = $(this).attr('media-key');
  var ident = $(this).attr('media-ident');
  var category = $(this).attr('media-category');

  data['type'] = type;
  data['key'] = key;
  data['ident'] = ident;
  data['category'] = category;
  data['media'] = {};

  $(this).find('.gallery-img').each(function(){
    data['media'][i] = $(this).attr('media-id');
    i++;
  });
  
  setTimeout( function(){

  $.ajax({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    },
    url: '/ajax/media/reorder',
    type: 'post',
    data: {'data' : data},
    success: function(html){   
      $('.saveSuccess').addClass('d-block').fadeOut();

      window.setTimeout(function(){
        $('.circle-loader').addClass("load-complete");
        $('.checkmark').toggle();
        $('.saved').removeClass('d-none');
      }, 400) ; //<-- Delay in milliseconds

      window.setTimeout(function(){
        $('.saveSuccess').removeClass('d-block').addClass('d-none');
         $('.checkmark').toggle();
      }, 3000); //<-- Delay in milliseconds

      $('[media-refresh="'+ident+'"]').html(html);
      $('[media-modal="'+ident+'"]').hide();
      var group = $('input[name=group]').val();
      console.log(group);
      $('<input type="hidden" name="group" value="'+group+'">').appendTo('form');
    }

  });

  }, time)
  time +=200;
  });

});
