<?php

namespace Clevercherry\Gridview;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Event;

use Clevercherry\Gridview\Commands\GenerateGrid;
use Clevercherry\Gridview\ModalRenderer;

class GridviewServiceProvider extends ServiceProvider
{
     /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot() {
        
        $this->loadHelpers();

        $this->loadViewsFrom(__DIR__ . '/resources/views', 'clevercherry');

        $this->loadPackageConfig();

        $this->loadPackageAssets();

        $this->registerCustomEvents();
    }

    /**
     * Load helper function files
     *
     * @return void
     */
    protected function loadHelpers(): void {
        $files = glob(__DIR__ . '/Helpers/*.php');
        foreach ($files as $file) {
            require_once($file);
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register() {

        $this->commands(GenerateGrid::class);
        $this->registerServices();
    }

    /**
     * Register app services
     *
     * @return void
     */
    public function registerServices() {
        $this->app->singleton('modal', function ($app) {
            return new ModalRenderer();
        });
    }

    /**
     * Register custom events
     *
     * @return void
     */
    public function registerCustomEvents(): void {
        Event::listen('grid.fetch_data', 'Clevercherry\\Gridview\\Listeners\\HandleUserAction@handle');
        Event::listen('grid.column_processed', 'Clevercherry\\Gridview\\Listeners\\AddExtraAttributesToProcessedColumn@handle');
        Event::listen('grid.initialized', 'Clevercherry\\Gridview\\Listeners\\GridWasInitialized@handle');
    }

    /**
     * Load package assets
     * To load use: 
     * php artisan vendor:publish --provider="Clevercherry\Gridview\GridServiceProvider"
     * @return void
     */
    public function loadPackageAssets(): void {
        $this->publishes([
            __DIR__ . '/resources/views' => base_path('resources/views/vendor/clevercherry')
        ], 'views');

        // only publish compiled assets
        $this->publishes([
            __DIR__ . '/resources/assets/dist' => base_path('public/clevercherry/grid')
        ], 'assets');
    }

    /**
     * Load package config
     * To load use:
     * php artisan vendor:publish --provider="Clevercherry\Gridview\GridServiceProvider" --tag="config"
     * 
     * @return void
     */
    public function loadPackageConfig(): void {
        $this->publishes([
            __DIR__ . '/resources/config/grid.php' => config_path('grid.php')
        ], 'config');
    }
}
