<?php

/**
 * Handles the grid.fetch_data Event
 *
 */
namespace Clevercherry\Gridview\Listeners;

use Clevercherry\Gridview\Events\UserActionRequested;

class HandleUserAction {

    /**
     * Create the event listener.
     *
     */
    public function __construct() {
        //
    }

    /**
     * Handle the event.
     *
     * @param  UserActionRequested $event
     * @return mixed
     * @throws \Throwable
     */
    public function handle(UserActionRequested $event) {

        if (!empty($event->request->query())) {

            if ($event->request->has($event->grid->getGridSearchParam())) {
                // grid search
                (new SearchDataHandler(
                    $event->grid, $event->request,
                    $event->builder, $event->validTableColumns, $event->args
                ))->searchRows();

            } else {
                // form filter
                (new FormFilterHandler(
                    $event->grid, $event->request,
                    $event->builder, $event->validTableColumns, $event->args
                ))->filterRows();
            }

            // sort
            (new SortDataHandler(
                $event->grid, $event->request,
                $event->builder, $event->validTableColumns, $event->args
            ))->sort();
        }

        $paginator = (new GridPaginationHandler($event->grid, $event->request, $event->builder));

        // export
        if ($event->request->has($event->grid->getGridExportParam())) {
            // do not export at this point
            return [
                'exporter' => (new DataExportHandler(
                    $event->grid, $event->request,
                    $event->builder, $event->validTableColumns, $event->args
                )),
                'data' => $paginator->paginate()
            ];
        }
        // paginate
        return $paginator->paginate();
    }
}