@props([
    'id' => null,
    'label' => null,
    'value' => [],
    'bsblockindex' => '',
    'overlay' => 0,
    'fields' => 'alt',
    'hint' => '',
    'extraAttributes' => [],
])


@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'input'
        ]);

    //set a default image
    if(!isset($value) || empty($value))
        $value=[];

    if(empty($bsblockindex) && is_string($value))
        $value=json_decode($value, true);

    if(is_string($value))
        $value=[];

    $showImg=true;
    if(!isset($value['id']))
    {

        $showImg=false;
        $url='';
        //$defaultmedia = \App\Models\MediaManager::defaultImage();
        $value['id'] = 0; //$defaultmedia->id;
        $value['alt'] = ''; //basename($defaultmedia->bestPath());
    }

    if (empty($value['id']) || ($value['id']<=0)) //because it may of been reset to -1
    {
        $showImg=false;
        $url='';
        //$defaultmedia = \App\Models\MediaManager::defaultImage();
        $value['id'] = 0; //$defaultmedia->id;
        $value['alt'] = ''; //basename($defaultmedia->bestPath());
    }

    if($showImg)
        $url = \App\Models\MediaManager::getMediaItem(@$value['id'])->thumbnailUrl();

    //fields alt is hardcoded
    $temparray = explode(',',str_replace(' ','',$fields));
    $realfields = [];
    foreach($temparray as $item)
    {   //tidy them up to lowercase and remove spaces from the CSV
        $tr = strtolower(trim($item));
        if(!empty($tr) && $tr!='alt')
            $realfields[]=$tr;
    }

@endphp

<x-bs-form.group>
    @if(!empty($label))
        <x-bs-form.label 
            label="{{ $label }}"
        />
    @endif
    <x-bs-form.hint class="mt-0 mb-2">
        {{ $hint }}
    </x-bs-form.hint>
    <div class="gallery bs4SingleMediaEdit bs4BlockSubItem bs4MediaItem" 
         data-role="bs4SingleMediaEdit" data-blockindex="{{ $bsblockindex }}">
        <div class="media-item" data-overlay="true">
            @if(empty($bsblockindex))                
                {{-- not in use in a block editor so it needs it's own json field--}}
                <input type="hidden" id="{{ $id }}" {{ $attributes }} value="{{ json_encode($value) }}" />
            @endif
            <div class="media-item__inner">
                <img class="media-item__preview @if(!$showImg) sr-only @endif" 
                     bsblockindex="{{ $bsblockindex }}" 
                     data-uid="{{ uniqid('bs4img',true) }}" 
                     data-json-name="id" 
                     value="{{ @$value['id'] }}" 
                     src="{{ $url }}" 
                     alt="{{ @$value['alt'] }}" />
                <div class="media-placeholder__inner @if($showImg) sr-only @endif">
                    <x-bs-featured-icon 
                        data-action="add-media"
                        icon="image-add"
                        size="lg"
                        theme="primary"
                        variant="circle"
                    />
                </div>
            </div>
            <div class="media-item__overlay @if(!$showImg) sr-only @endif">
                <x-bs-action
                    icon="edit"
                    size="sm"
                    tag="span"
                    theme="secondary"
                />
            </div>
            @foreach ($realfields as $aField)
                <span class="bs4MediaItem__field" 
                      bsblockindex="{{ $bsblockindex }}" 
                      data-json-name="{{ $aField }}" 
                      value="{{ @$value[$aField] }}" ></span>
            @endforeach
        </div>
    </div>
</x-bs-form.group>