 

/**
 * 
 * @param {*} value 
 * @returns 
 */

const toggleSelectResults = (select) => {
    const open = select.getAttrribute('data-show-results');

    if (open) {
        select.setAttribute('data-show-results', 'false');
    } else {
        select.setAttribute('data-show-results', 'true');
    }
}

/**
 * 
 * @param {*} value 
 * @returns 
 */

const showSelectResults = (select) => {
    select.setAttribute('data-show-results', 'true');
}


/**
 * 
 * @param {*} value 
 * @returns 
 */

const hideSelectResults = (select) => {
    select.setAttribute('data-show-results', 'false');
}


/**
 * 
 * @param {*} value 
 * @returns 
 */

const createSelectTag = (value) => {
    if (!value) return false;

    const tag = document.createElement('span');
    const label = document.createElement('span');
    const action = document.createElement('button');
    tag.classList.add('tag');
    tag.dataset.value = value;
    tag.dataset.size = 'md';
    label.classList.add('tag__label');
    label.textContent = value.replace(/_/g, ' ');
    action.classList.add('tag__action');
    action.textContent = 'x';
    action.dataset.action = 'remove-select-tag';

    tag.appendChild(label);
    tag.appendChild(action);

    return tag;
}


/**
 * 
 * @param {*} value 
 * @returns 
 */

const removeSelectTag = (tag) => {
    const select = tag.closest('.tag-select');
    const input = select.querySelector('[data-role=tag-select-values]');
    const tags = select.querySelectorAll('.tag');
    tag.remove();

    updateSelectTagInput(select);
}


/**
 * 
 */

const updateSelectTagInput = (select) => {
    const input = select.querySelector('[data-role=tag-select-values]');
    const tags = select.querySelectorAll('.tag');
    const values = [];

    tags.forEach((tag) => {
        const tagValue = tag.dataset.value;
        values.push(tagValue);
    })

    values.join(',');
    input.setAttribute('value', values);
    updateSelectTagOptions(select);
}


/**
 * 
 */

const updateSelectTagOptions = (select) => {
    const input = select.querySelector('[data-role=tag-select-values]');
    const options = select.querySelectorAll('[data-role=tag-select-option]');
    const optionsArr = Array.from(options);
    const tags = select.querySelectorAll('.tag');
    const tagsArr = Array.from(tags);

    options.forEach((option) => {
        if (tagsArr.find(element => element.dataset.value === option.dataset.value)) {
            option.dataset.active = 'true';
        } else {
            option.dataset.active = 'false';
        }
    })
}


/**
 * 
 * @param {*} event 
 * @returns 
 */

const addSelectTag = (select, newValue) => {
    const search = select.querySelector('.tag-select__input-search');
    const input = select.querySelector('.tag-select__input');
    const options = select.querySelectorAll('[data-role=tag-select-option]');
    const optionsArr = Array.from(options);
    const valueInput = select.querySelector('[data-role=tag-select-values]');

    const tag = createSelectTag(newValue);
    input.insertBefore(tag, search);
    search.value = '';
    updateSelectTagInput(select);
}


/**
 * 
 * @param {*} event 
 * @returns 
 */

const addSelectTagFromSearch = (select, newValue) => {
    const search = select.querySelector('.tag-select__input-search');
    const input = select.querySelector('.tag-select__input');
    const options = select.querySelectorAll('[data-role=tag-select-option]');
    const optionsArr = Array.from(options);
    const valueInput = select.querySelector('[data-role=tag-select-values]');

    if (Array.from(options).find(element => element.dataset.value.toLowerCase() == newValue.toLowerCase())) {
        search.value = '';
        return false;
    }

    const tag = createSelectTag(newValue);
    input.insertBefore(tag, search);
    search.value = '';
    updateSelectTagInput(select);
}



document.querySelectorAll('.tag-select').forEach((select) => {
    const search = select.querySelector('.tag-select__input-search');
    const options = select.querySelector('.tag-select__options');

    search.addEventListener('keyup', (event) => {
        if (event.key === 'Enter') {
            addSelectTagFromSearch(select, search.value);
        }
    });
    
    search.addEventListener('focus', (event) => {
        showSelectResults(select);
    });
    
    search.addEventListener('blur', (event) => {
        setTimeout(function() {
            hideSelectResults(select);
        }, 100)
    });

})

document.addEventListener('click', (event) => {    
    if (event.target.matches('[data-role=tag-select-option]')) {
        event.preventDefault();

        if (event.target.getAttribute('data-active') == 'true') return false
        
        addSelectTag(event.target.closest('.tag-select'), event.target.getAttribute('data-value'));
    }

    if (event.target.matches('[data-action=remove-select-tag]')) {
        removeSelectTag(event.target.closest('.tag'));
    }
})