<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\View;
use App\Models\Page;
use Clevercherry\Backslash4\Backslash4;
use Illuminate\Support\Str;
class PageController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $item = Page::where('slug', '')->active()->first();
        if($item==null)
            $item = Page::where('slug', '/')->active()->first();

        if(!$item)
        {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0))
        { 
            if(view()->exists('tenant::pages.index'))
                return view('tenant::pages.index')->with('item', $item);
            //else
            if(view()->exists('tenant::pages.view'))
                return view('tenant::pages.view')->with('item', $item);
        }
        //else

        if(view()->exists('pages.index'))
            return view('pages.index')->with('item', $item);
        //else
        if(view()->exists('pages.view'))
            return view('pages.view')->with('item', $item);
        // else
        return view('backslash4::generic.view')->with('item', $item);
    }

    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        $item = Page::where('slug', end($params))->active()->first();
        
        if(!$item)
        {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::pages.view'))
            return view('tenant::pages.view')->with('item', $item);
        //else

        if(view()->exists('pages.view'))
            return view('pages.view')->with('item', $item);
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }

    public function viewEnquiryThankYou(Request $request)
    {
        return $this->view($request->path());
    }
 
    /**
     * Creates a dynamic robots.txt file based on the current APP_ENV setting
     * @return type
     */
    public function robots()
    {
        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::robots'))
            $content = View::make('tenant::robots');
        else if(view()->exists('robots'))
            $content = View::make('robots');
        else
            $content = View::make('backslash4::robots');
        
        return Response::make($content)->header('Content-Type', 'text/plain;charset=utf-8');
    }

    /**
     * Returns a view of the XML sitemap for search engines
     * @return type
     */
    public function sitemap()
    {
        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::sitemap.xml'))
            $sitemapview = 'tenant::sitemap.xml';
        else if(view()->exists('sitemap.xml'))
            $sitemapview = 'sitemap.xml';
        else
            $sitemapview = 'backslash4::sitemap.xml';

        $content = View::make($sitemapview)
            ->with('sitemap', '');
        
        return Response::make($content)->header('Content-Type', 'text/xml;charset=utf-8');
    }

    public function sitemapPage($slug)
    {
        $sitemaps = self::getSitemaps();
        if(!in_array($slug, $sitemaps))
            abort(404);

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::sitemap.pages_xml'))
            $sitemapview = 'tenant::sitemap.pages_xml';
        else if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::sitemap.pages_xml'))
            $sitemapview = 'tenant::sitemap.xml';
        else if(view()->exists('sitemap.pages_xml'))
            $sitemapview = 'sitemap.pages_xml';
        else if(view()->exists('sitemap.xml'))
            $sitemapview = 'sitemap.xml';
        else
            $sitemapview = 'backslash4::sitemap.xml';

        $content = View::make($sitemapview)
            ->with('sitemap', $slug);

        return Response::make($content)->header('Content-Type', 'text/xml;charset=utf-8');
    }

    public function sitemap_index()
    {
        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::sitemap.index_xml'))
            $indexview = 'tenant::sitemap.index_xml';
        else if(view()->exists('sitemap.index_xml'))
            $indexview = 'sitemap.index_xml';
        else 
            $indexview = 'backslash4::sitemap.index_xml';
        
        $content = View::make($indexview)
                        ->with('sitemaps', self::getSitemaps());
        
        return Response::make($content)->header('Content-Type', 'text/xml;charset=utf-8');
    }

    public static function getSitemaps()
    {
        $sitemaps=[];
        foreach(Backslash4::getDashboardFlatCMS() as $key => $configItem)
	    {
            if(!empty($configItem) && !isset($configItem['html']))
            {
                $model = false;
			    $modelPath = '\App\Models\\' . Str::singular($key);

			    if(class_exists($modelPath)) {
				    $sitemaps = array_merge($sitemaps, ($modelPath)::getSiteMapPages());
			    }
            }
        }        
        return array_unique($sitemaps, SORT_REGULAR);
    }
}
