@props([
    'action' => 'dismiss-tag',
    'icon' => null,
    'label' => null,
    'href' => ''
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'tag'
        ]);
@endphp

<span {{ $attributes }}>
    @if(!empty($href))
    <a target="_blank" href="{{ $href }}">
    @endif
    @if ($icon)
        <x-bs-icon 
            :icon=$icon
            size="xs" 
        />
    @endif
    @if($label || !$slot->isEmpty())
        <div class="tag__label">
            {{ $label ?? $slot }}
        </div>
    @endif
    @if(!empty($href))
    </a>
    @endif
    <button class="tag__action" data-role="tag-dismiss" data-action="{{ $action }}">
        <x-bs-icon 
            icon="cross"
            size="xs" 
        />
        <span class="sr-only">Remove {{ $label }}</span>
    </button>
</span>