@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'options' => [],
    'firstoption' => '',
    'selected' => '',
    'required' => '',
    'hint' => '', 
    'reversepairs' => 0,
    'fieldwidth' => null,
    'extraAttributes' => [],
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'select',
        ]);

    // so we can pass down some stuff through autogeneric extraAttributes
    if(is_array($extraAttributes) && isset($extraAttributes['firstoption']))
        $firstoption=$extraAttributes['firstoption'];
        
@endphp

<x-bs-form.group class="{{ $group['class'] }}" :width=$fieldwidth>
    @if(!empty($label))
    <x-bs-form.label 
        :label=$label 
        :for="$id" />
    @endif
    <select {{ $required }}  {{ $attributes }} {{ $id  ? "id=$id" : "" }}>
        {{ $slot }}
        @foreach ($options as $a => $b)
            @php
            if(empty($reversepairs))
            {   $value = $a;
                $label = $b;
            } else
            {   $value = $b;
                $label = $a;
            }
            @endphp
            <option value="{{$value}}" {{ ($selected==$value) ? 'selected' : '' }} {{($loop->first) ? $firstoption : ""}}>
                {{ $label }}
            </option>
        @endforeach
    </select>
    @if ($hint)
        <p class="form-hint mt-1">{{ $hint }}</p>
    @endif
</x-bs-form-group>