import { defineConfig } from 'vite'

export default defineConfig({
    mode : 'production',
    publicDir : false,
    build: { 
      lib: {
        // Could also be a dictionary or array of multiple entry points
        entry: 'src/main.js',
        name: 'nicEditXX',
        // the proper extensions will be added
        fileName: 'nicEditXX'
      },
      // generate manifest.json in outDir
      manifest: false,
      copyPublicDir : false,
      outDir : 'public',
      assetsDir :  './',
      minify: true,
      rollupOptions: {
        // overwrite default .html entry
        input: 'src/main.js',
        output: [
            {
              dir: 'public',
              format: 'esm', //
              plugins : []
            },
            {
              dir: 'public/min',
              format: 'esm',
              compact : true,
              plugins : []
            }
          ],
      }
    }  
  })