import { toggleAttribute } from '../helpers/toggle-attribute';

export default () => {
    const sidebar = document.querySelector('.sidebar');           

    /**
     * 
     * @param {Element} sidebar - sidebar element
     */
    const toggleSidebar = (sidebar) => {
        let state = sidebar.getAttribute('data-state');

        if (state === 'closed') {
            sidebar.setAttribute('data-state', 'open');
            document.documentElement.classList.add('scroll-lock');

        } else {
            sidebar.setAttribute('data-state', 'closed');
            document.documentElement.classList.remove('scroll-lock');
        }
    }

    document.addEventListener('click', (event) => {
        if (event.target.matches('[data-action=toggle-sidebar]')) {
            event.preventDefault();
            toggleAttribute(event.target, 'aria-expanded');
            toggleSidebar(sidebar);
        } //else bs4.log('ccdev 028 - lick not trapped in header');
    })
}