@props([
    'field' => null,
    'heading' => null,
    'order' => 'asc',
    'sorted' => null
])

@php
    $attributes = $attributes
        ->merge([
            'type' => 'button',
            'data-role' => 'sort-listing',
            'data-sorted' => $sorted,
            'data-sort-field' => $field,
            'data-sort-order' => $order,
        ])
        ->class([
            'table__heading-sort'
        ]);
@endphp

<button {{ $attributes }}>
    {{ $heading }}
    <x-bs-icon
        icon="sort-ascending"
        size="xs"
    />
</button>