@php
  $extraColumnsA = ($appModel)::getExtraListingColumnsA();
  $extraColumnsB = ($appModel)::getExtraListingColumnsB();
  $hideColumns = ($appModel)::hideStandardColumns();

  if(!isset($indent)){
      $indent = 0;
  }
@endphp

<x-bs-table>
    @include('backslash4::admin.generic.index-header', 
                [ 'extraColumnsA' => $extraColumnsA, 
                  'extraColumnsB' => $extraColumnsB, 
                  'hideColumns'=>$hideColumns])
    <x-bs-table.body>
        @foreach ($items as $item)
            @php( $rowindent = $item->getRowIndent($indent) )
            @include('backslash4::admin.generic.index-item-row', 
                [ 'extraColumnsA' => $extraColumnsA, 
                  'extraColumnsB' => $extraColumnsB, 
                  'hideColumns'=>$hideColumns,
                  'indent' => $rowindent])
        @endforeach
    </x-bs-table.body>
</x-bs-table>

<x-bs-card.footer>
    <x-bs-pagination 
        :$items 
        :path="($appModel)::getDataAjaxUrl($adminRoute)"
        {{-- :route="$adminRoute.'.index.ajax'" obsolete --}}
    />
</x-bs-card.footer>