<?php
namespace Clevercherry\Backslash4\Resolvers;

use Clevercherry\Backslash4\Backslash4;
use Illuminate\Database\ConnectionResolverInterface;
use Illuminate\Database\ConnectionInterface;
use Doctrine\DBAL\Types\Type;
use Illuminate\Database\Connectors\ConnectionFactory;
use Illuminate\Support\Arr;
use Illuminate\Support\ConfigurationUrlParser;
use Illuminate\Support\Str;
use Illuminate\Support\Traits\Macroable;
use InvalidArgumentException;
use PDO;
use RuntimeException;

class TenantConnectionResolver implements ConnectionResolverInterface
{

    /**
     * All of the registered connections.
     *
     * @var \Illuminate\Database\ConnectionInterface[]
     */
    protected $connections = [];

    /**
     * The default connection name.
     *
     * @var string
     */
    protected $default;

    /**
     * Create a new connection resolver instance.
     *
     * @param  array<string, \Illuminate\Database\ConnectionInterface>  $connections
     * @return void
     */
    public function __construct(array $connections = [])
    {
        foreach ($connections as $name => $connection) {
            $this->addConnection($name, $connection);
        }
    }

    /**
     * Get a database connection instance.
     *
     * @param  string|null  $name
     * @return \Illuminate\Database\ConnectionInterface
     */
    public function connection($name = null)
    {
        if (is_null($name)) {
            $name = $this->getDefaultConnection();
        }

        return $this->connections[$name];
    }

    /**
     * Add a connection to the resolver.
     *
     * @param  string  $name
     * @param  \Illuminate\Database\ConnectionInterface  $connection
     * @return void
     */
    public function addConnection($name, ConnectionInterface $connection)
    {
        $this->connections[$name] = $connection;
    }

    /**
     * Check if a connection has been registered.
     *
     * @param  string  $name
     * @return bool
     */
    public function hasConnection($name)
    {
        return isset($this->connections[$name]);
    }

    /**
     * Get the default connection name.
     *
     * @return string
     */
    public function getDefaultConnection()
    {
        return $this->default;
    }

    /**
     * Set the default connection name.
     *
     * @param  string  $name
     * @return void
     */
    public function setDefaultConnection($name)
    {
        $this->default = $name;
    }
}



/*

    $conn = config('database.default', 'mysql');
    $key = Backslash4::getTenantKey();
    if(!empty($key))
    {

        $tenantDatabase = config('backslash4.tenants.'.$key.'.database', null);
        if(!empty($tenantDatabase))
        {
            $conn = config('database.default');
            $dbConfig = config('database.connections.'.$conn);

            $dbConfig['database']=$tenantDatabase;
            config('database.connections.tenant-'.$key);
            

            DB::disconnect();
            $this->setConnection('tenant-'.$key);
            //DB::setDatabaseName(' $tenantDatabase');
            //config(['database.connections.'.$conn.'.database', $tenantDatabase]);
            DB::reconnect();
        }
*/
