@props([
    'action' => false,
    'href' => null,
    'icon' => null,
    'type' => null
])

@php
    $attributes = $attributes
        ->merge([
            'data-action' => $action
        ])
        ->class([
            'widget'
        ])
@endphp

@if (!empty($href))
    <a {{ $attributes->merge(['href' => $href]) }}>
        {!! $slot !!}
    </a>
@elseif (!empty($type))
    <button {{ $attributes->merge(['type' => $type]) }}>
        {!! $slot !!}
    </button>
@else
    <div {{ $attributes }}>
        {!! $slot !!}
    </div>
@endif