@props([
    'id' => null,
    'module' => null,
    'message' => null,
    'itemname' => null,
])


<x-bs-modal id="duplicate-post-item-modal" size="md" data-role="duplicate-post-item-modal">
    <x-bs-modal.header
        direction="row"
        :icon="[
            'icon' => 'folder-plus',
            'theme' => 'primary'
        ]"
        title="Duplicate item"
        text="Please enter the number of times you would like to duplicate this item"
    />
    <form action="{{ route('admin.' . $module . '.duplicate', ['id' => $id]) }}" method="get">
        <x-bs-modal.content>
            <x-bs-form.input
                name="amount"
                id="amount"
                type="number"
                placeholder="e.g. 4"
            />
            @if($module != "plots")
            <x-bs-form.select 
                name="development"
                label="Select Development" 
                :options="Development::listingOptions()"
             />
             @endif
        </x-bs-modal.content>
        <x-bs-modal.actions>
            <x-bs-button 
                size="lg"
                id="duplicate-ok-item-modal"
                text="Duplicate"
                theme="primary"
                type="submit" 
            />
            <x-bs-button
                size="lg"
                text="Cancel"
                theme="secondary"
                type="button"
                data-a11y-dialog-hide
                aria-label="Close dialog" 
            />
        </x-bs-modal.actions>
    </form>
</x-bs-modal>