<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use App\Models\Product;

class ProductController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $items = Product::active()->get();

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::products.index'))
            return view('tenant::products.index')->with('items', $items);
        //else

        if(view()->exists('products.index'))
            return view('products.index')->with('items', $items);
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.index')->with('items', $items);
    }

 
    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        if( empty(Request()->preview) 
            || empty(Product::allowPreviewAlgorithm()) 
            ||  (Request()->preview!=hash( Product::allowPreviewAlgorithm(), end($params)) ) )
        {
            $item = Product::where('slug', end($params))->active()->first();
        } else
        {
            // preview param exists and matches the slug's hash so allow any pages
            $item = Product::where('slug', end($params))->first();
        }

        if(!$item) {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::products.view'))
            return view('tenant::products.view')->with('item', $item);
        //else
        
        if(view()->exists('products.view')) {
            return view('products.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }
}
