@props([
    'formGroup' => true,
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'text' => null,
    'type' => 'text',
    'required' => '',
    'hint' => null,
    'extraattributes' => '',
    'col',
    'fieldwidth' => null
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'input'
        ]);
    
    $lookupLabel = 'Lookup';
    $lookupCountry = '';
    if(is_array($extraattributes)){
        
        if(isset($extrattributes['lookup-label']))
            $lookupLabel = $extrattributes['lookup-label'];

        if(isset($extrattributes['lookup-country']))
            $lookupCountry = $extrattributes['lookup-country'];
    }

    $lookupRoute = route('admin.apis.google.geolocation');
@endphp

@if (!empty($text))
    <div>
        @if (!empty($label))
            <x-bs-form.label
                for="{{ $id }}" 
                :label=$label 
            />
        @endif
        <x-bs-form.group class="{{ $group['class'] }}">
            <div class="form-text">
                {{ $text }}
            </div>        
            <input 
                {{ $attributes }} {!! $extraattributes !!}
                id="{{ $id }}" 
                type="{{ $type }}" 
                {{ $required }} 
            />
            <x-bs-button 
                data-role='bsLatLongLookupButton' 
                :data-href="$lookupRoute"
                :data-country='$lookupCountry'>{!! $lookupLabel !!}</x-bs-button>
        </x-bs-form.group>
        @if ($hint)
            <p class="form-hint">{{ $hint }}</p>
        @endif
    </div>
@else
    @if ($formGroup === true)
        <x-bs-form.group class="{{ $group['class'] }}" :width=$fieldwidth>
            <x-bs-form.label
                for="{{ $id }}" 
                :label=$label 
            />
            <input 
                {{ $attributes }} {!! $extraattributes !!}
                id="{{ $id }}" 
                type="{{ $type }}" 
                {{ $required }} 
            />
            <x-bs-button 
                data-role='bsLatLongLookupButton' 
                :data-href="$lookupRoute"
                :data-country='$lookupCountry'>{!! $lookupLabel !!}</x-bs-button>
            <x-bs-form.hint
                :text=$hint
            />
        </x-bs-form.group>
    @else
        <x-bs-form.label
            for="{{ $id }}" 
            :label=$label 
        />
        <input 
            {{ $attributes }} {!! $extraattributes !!}
            id="{{ $id }}" 
            type="{{ $type }}" 
            {{ $required }} 
        />
        <x-bs-button 
                data-role='bsLatLongLookupButton' 
                :data-href="$lookupRoute"
                :data-country='$lookupCountry'>{!! $lookupLabel !!}</x-bs-button>
        <x-bs-form.hint
            :text=$hint
        />
    @endif
@endif