@props([
    'item' => null,
    'fieldname' => '',
    'hiddenFilters' => [],
])
@php
    $fieldtype = $item->getFieldType($fieldname);
    $fieldtab = $item->getFieldTab($fieldname);
    
    //the actual value
    $attr = $item->getAttribute($fieldname);
    if($attr===null)
    { 
        //although this function exists you proabbly want to do something in the constructor
        $attr = $item->getDefaultFieldValue($fieldname, null);
    }

    $required = $item->getFieldRequired($fieldname);

    $label = $item->translateFieldName($fieldname) . (!empty($required) ? ' *' : '');
    if(false)  //debug
        $label .= '['.$item->getAttribute($fieldname).']';

    $hint = $item->getHintText($fieldname);
    $placeholder = $item->getPlaceholderText($fieldname);
    $modelName = Str::Singular($item->getTable());
    $readonly=null;
    $disabled=null;
    if( Str::endsWith($fieldtype,":readonly") || Str::endsWith($fieldtype,":read-only") )
    {   $readonly=true;
        $disabled=true;
        $fieldtype = explode(":",$fieldtype,2)[0];
    }
    $extraAttributes = @$item->getFieldAttributes($fieldname) ?? 'test="90210"';

    //insert extra html before and after field
    
    $renderBeforeField = @$item->renderBeforeField($fieldname) ?? '';
    $renderAfterField = @$item->renderAfterField($fieldname) ?? '';
    $fieldwidth = @$item->getFieldWidth($fieldname) ?? 'col-span-1';

    
@endphp
{!! $renderBeforeField  !!}
@switch($fieldtype)
    @case('id')
        @if(!empty($attr))
            <x-bs-form.id :value="$attr" />
        @endif
        @break
    @case('not-on-form')
        @break
    @case('readonly') {{-- special use case --}}
        <x-bs-form.input 
            type="text"
            readonly disabled 
            :label="$label" :hint="$hint" :extraAttributes="$extraAttributes" :fieldwidth="$fieldwidth"
            :value="$attr" />
        @break
    @case('choose-options-readonly') {{-- special use case --}}
    @case('readonly-choose-options') {{-- special use case --}}
        @php
            $options = $item->getChooseOptions($fieldname);
        @endphp
        <x-bs-form.input
            type="text" 
            readonly disabled
            :label="$label" :hint="$hint" :extraAttributes="$extraAttributes" :fieldwidth="$fieldwidth"
            value="{{ @$options[$attr] ?? 'null' }}"  
        />
        @break
    @case('hidden')
        <x-bs-form.input 
            type="hidden"
            id="{{ $fieldname }}"
            name="{{ $fieldname }}"
            label="" 
            :value="$attr"
            :extraAttributes="$extraAttributes" 
        />
        @break
    @case('rich-text-editor')
    @case('rich-text-edit')
    @case('rich-text')
    @case('richtext')
    @case('richtexteditor')
        <x-bs-form.textarea
            richtexteditor 
            id="{{ $fieldname }}"
            name="{{ $fieldname }}"
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :hint="$hint" :extraAttributes="$extraAttributes" >{{ $attr }}</x-bs-form.textarea>
        @break
    @case('text-area')
        <x-bs-form.textarea 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :hint="$hint" :extraAttributes="$extraAttributes" >{{ $attr }}</x-bs-form.textarea>
        @break
    @case('check')
    @case('check-box')
        <x-bs-form.check 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            value="1" 
            :checked=$attr
            :label="$label" :hint="$hint" :readonly="$readonly" :disabled="$disabled"  :extraAttributes="$extraAttributes" :fieldwidth="$fieldwidth"
        />
        @break
    @case('switch')        
        <x-bs-form.switch
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            value="1" 
            :switch=$attr 
            :label="$label" :hint="$hint" :readonly="$readonly" :disabled="$disabled" :extraAttributes="$extraAttributes" :fieldwidth="$fieldwidth"
        />
        @break
    @case('choose-option')
    @case('choose-options')
        @php
            //note this will be a text field if the model returned is null, if no list
            $options = $item->getChooseOptions($fieldname);
        @endphp
        @if($options==null)
            <x-bs-form.input 
                type="text"
                id="{{ $fieldname }}"
                name="{{ $fieldname }}" 
                :value="$attr"
                :label="$label" :hint="$hint" :required="$required" :readonly="$readonly" :disabled="$disabled" :placeholder="$placeholder" :extraAttributes="$extraAttributes" :fieldwidth="$fieldwidth"
            />
        @else
            <x-bs-form.select 
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :required="$required" :readonly="$readonly" :disabled="$disabled" 
                :label="$label" :hint="$hint" :placeholder="$placeholder" :fieldwidth="$fieldwidth"
                firstoption="disabled readonly" :options="$options"  :selected="$attr ?? 0" 
                :extraAttributes="$extraAttributes" 
            />
        @endif
        @break
    @case('choose-options-checkbox')
        @php
            //note this will be a text field if the model returned is null, if no list
            $options = $item->getChooseOptions($fieldname);
            
            //so that mySQL 'set', which returns a CSV will work -- any CSV in fact
            // note you will have process it anyway in public function checkBeforeSave($store): array
            // as this return an array, which you must either json_encode or implode anyway
            if(!Str::startsWith($attr,'[') && !Str::endsWith($attr,']')
                && !Str::startsWith($attr,'{') && !Str::endsWith($attr,'}'))
                $attr=json_encode(explode(',',$attr));
        @endphp
        @if($options==null)
            <x-bs-form.input
                type="text" 
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :required="$required" :readonly="$readonly" :disabled="$disabled"
                :label="$label" :hint="$hint" :placeholder="$placeholder" :fieldwidth="$fieldwidth"
                :value="$attr"
                :extraAttributes="$extraAttributes" 
            />
        @else
            <x-bs-form.checkboxes-multiple 
                fieldname="{{ $fieldname }}" 
                :label="$label" 
                :options="$options" 
                :checked=$attr  
                :extraAttributes="$extraAttributes" 
                :fieldwidth="$fieldwidth"
            />
        @endif
        @break
    @case('choose-parents')
        @php
            $options = $item->getChooseParents($fieldname);
        @endphp
        @if($options==null)
            <x-bs-form.input 
                type="text" 
                id="{{ $fieldname }}" name="{{ $fieldname }}"
                :readonly="$readonly" :disabled="$disabled" :required="$required"
                :label="$label" :hint="$hint" :placeholder="$placeholder" :extraAttributes="$extraAttributes" :fieldwidth="$fieldwidth"
                :value="$attr" />
        @else
            <x-bs-form.select :required="$required" id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :readonly="$readonly" :disabled="$disabled"
                :label="$label" :hint="$hint" :placeholder="$placeholder" :extraAttributes="$extraAttributes" :fieldwidth="$fieldwidth"
                :options="$options" 
                :selected="$attr ?? 0"  />
        @endif
        @break
    @case('download-file')
        <x-bs-form.download-button
            name="{{ $fieldname }}" 
            :value="$attr"
            :item=$item
            :extraAttributes="$extraAttributes"
        />
        @break
    @case('file-options')
    @case('files-options')
        @php
            $max = ($fieldtype=='file-options') ? '1' : '';
            $type = $item->getFieldUploadTypes($fieldname)
        @endphp
            <x-bs-form.files-upload
                :name="$fieldname"
                :id="$fieldname"
                :required="$required"
                :label="$label" 
                :readonly="$readonly"
                :disabled="$disabled"
                :max="$max"
                :hint="$hint"
                :placeholder="$placeholder"
                :extraAttributes="$extraAttributes"
                :value="$attr" 
                :filerequirements=$type 
            />
        @break
    @case('data-list')
        @php
              $options = $item->getDataList($fieldname);
        @endphp
        @if($options==null)
            <x-bs-form.input 
                type="text"
                id="{{ $fieldname }}" name="{{ $fieldname }}"
                :required="$required" :readonly="$readonly" :disabled="$disabled"
                :label="$label" :hint="$hint" :placeholder="$placeholder"  :value="$attr"  :extraAttributes="$extraAttributes" 
            />
        @else
            <x-bs-form.datalist 
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :required="$required" :readonly="$readonly" :disabled="$disabled"
                :label="$label" :hint="$hint" :placeholder="$placeholder" :extraAttributes="$extraAttributes"
                :options="$options"  :selected="$attr ?? 0"   
            />
        @endif
        @break
    @case('tag-select')
        @php
              $options = $item->getTagList($fieldname);
        @endphp
            <x-bs-form.tag-select
                id="{{ $fieldname }}" 
                name="{{ $fieldname }}" 
                :required="$required"
                :readonly="$readonly" 
                :disabled="$disabled"
                :label="$label" 
                :hint="$hint" 
                :placeholder="$placeholder"
                :extraAttributes="$extraAttributes"
                :fieldwidth="$fieldwidth"
                :options="$options"  
                :selected="$attr ?? 0"
                :multiValue=false
            />
        @break
    @case('address')
        @php
            $options = $item->getChooseOptions($fieldname);
        @endphp
            <x-bs-form.address
                bs4address
                id="{{ $fieldname }}" name="{{ $fieldname }}" 
                :required="$required"  :readonly="$readonly" :disabled="$disabled"
                :label="$label" :hint="$hint" :placeholder="$placeholder" :extraAttributes="$extraAttributes"
                :value="$attr ?? '{}' " 
                firstoption="disabled readonly" :options="$options"  />
        @break
    @case('map-pins')
        <x-bs-maps.google-pin-editor
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :hint="$hint" :placeholder="$placeholder" :extraAttributes="$extraAttributes" 
            :value="$attr"
            />
        @break
    @case('money') {{-- prices stored in pennies --}}
        <x-bs-form.input 
            type="number"
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :hint="$hint" :placeholder="$placeholder" 
            step="0.01" 
            value="{{ number_format(round($attr,0)/100,2, '.', '') }}"
            :extraAttributes="$extraAttributes"  
            :fieldwidth="$fieldwidth"
        />
        @break
    @case('number')
        <x-bs-form.input 
            type="number" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :hint="$hint" :placeholder="$placeholder" 
            step="any"
            :value="$attr"
            :extraAttributes="$extraAttributes" 
            :fieldwidth="$fieldwidth"
        />
        @break
    @case('lat-long-lookup')
        <x-bs-form.lat-long-lookup
            type="number" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :hint="$hint" :placeholder="$placeholder" 
            step="any"
            :value="$attr"
            :extraAttributes="$extraAttributes" 
            :fieldwidth="$fieldwidth"
        />
        @break
    @case('password')
        <x-bs-form.input-counted 
            type="password"
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :readonly="$readonly" :disabled="$disabled"
            :label="$label" :hint="$hint" :extraAttributes="$extraAttributes" 
            placeholder="Password" 
            value=""
            minlength="6"
            :fieldwidth="$fieldwidth"
        />
        @break
    @case('slug')
        @php
            $menuSlug = Request::getSchemeAndHttpHost().$item->getFrontEndMenuSlug(true);
            if(!Str::endsWith($menuSlug,'/'))
                $menuSlug .='/';
        @endphp
        <x-bs-form.input-counted
            type="text" 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            :readonly="$readonly" {{-- do not use disabled, it will be unset and the code will regenerate it --}}
            :hint="$hint" :label="$label" :placeholder="$placeholder" :extraAttributes="$extraAttributes"
            :text=$menuSlug
            :value="$attr"
            :fieldwidth="$fieldwidth"
        />
        @break
    @case('tag-related')
        @php
            $allothers = $item->getAllOthers();
        @endphp
        <x-bs-form.tag-list 
            type="text" 
            id="{{ $fieldname }}" name="{{ $fieldname }}"
            :alltags=$allothers 
            :readonly="$readonly" :disabled="$disabled"
            :hint="$hint" :label="$label" :placeholder="$placeholder" :extraAttributes="$extraAttributes"
            :value="$attr"
            :fieldwidth="$fieldwidth"
        />
        @break
    @case('tag-field')
        @php
            $fieldtags = $item->getFieldTags($fieldname, true);
        @endphp
        <x-bs-form.tag-list 
            id="{{ $fieldname }}" name="{{ $fieldname }}"
            :alltags=$fieldtags :readonly="$readonly" :disabled="$disabled"
            :hint="$hint" :label="$label" :placeholder="$placeholder" 
            :value="$attr" 
            :extraAttributes="$extraAttributes" />
        @break
    @case('date')
        <x-bs-form.input 
            type="date" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :placeholder="$placeholder" :value="$attr"
            step="1"
            :extraAttributes="$extraAttributes" 
            :fieldwidth="$fieldwidth"
        />
        @break;
     @case('time')
        <x-bs-form.input 
            type="time" 
            id="{{ $fieldname }}" name="{{ $fieldname }}" 
            :required="$required" :readonly="$readonly" :disabled="$disabled"
            :label="$label" :placeholder="$placeholder" :value="$attr"
            step="1"
            :extraAttributes="$extraAttributes" 
            :fieldwidth="$fieldwidth"
        />
        @break; 
    @case('date-time')
        <x-bs-form.input 
            type="datetime-local"
            id="{{ $fieldname }}"
            name="{{ $fieldname }}" 
            :label="$label" :placeholder="$placeholder" :required="$required" :readonly="$readonly" :disabled="$disabled" :extraAttributes="$extraAttributes"
            :value="$attr"  
            step="1"
            :fieldwidth="$fieldwidth"
        />
        @break;
    @case('json')
        <x-bs-form.json name="{{ $fieldname }}" :json=$attr :fieldwidth="$fieldwidth" />
        @break;
    @case('media')
        @php( $fields = $item->getFieldMediaFields($fieldname) )
        <x-bs-form.media-single 
            type="text" 
            id="{{ $fieldname }}" 
            name="{{ $fieldname}}" 
            :label="$label" :readonly="$readonly" :disabled="$disabled" :required="$required" :hint="$hint" :placeholder="$placeholder" 
            :value="$attr" 
            :fields=$fields 
            :extraAttributes="$extraAttributes" />
        @break;
    @case('media-gallery')
        @php( $fields = $item->getFieldMediaFields($fieldname) )
        <x-bs-form.media-multiple 
            type="text" 
            id="{{ $fieldname }}" 
            name="{{ $fieldname }}" 
            :label="$label" 
            :readonly="$readonly" 
            :disabled="$disabled"
            :required="$required" 
            :hint="$hint" 
            :placeholder="$placeholder" 
            :value="$attr"
            :fields=$fields 
            :extraAttributes="$extraAttributes" />
        @break;
    @case('journey-tracker')
        <x-bs-form.journey-tracker
            :item="$item" 
            id="{{ $fieldname }}"
            name="{{ $fieldname }}"
            :label="$label"
            :placeholder="$placeholder"
            :required="$required" 
            :hint="$hint" 
            :readonly="$readonly" 
            :disabled="$disabled" 
            :value="$attr"
            :extraAttributes="$extraAttributes" 
            :fieldwidth="$fieldwidth" />
        @break;
    @case(Str::startsWith($fieldtype, 'custom.'))
        <x-dynamic-component 
            :component="'bs-form.' . $fieldtype" 
            :item="$item" 
            id="{{ $fieldname }}"
            name="{{ $fieldname }}"
            {{--  these, following attributes, may be ignored in your custom edit compoonent getting stuff from item, or can be used --}}
            :label="$label"
            :placeholder="$placeholder"
            :required="$required" 
            :hint="$hint" 
            :readonly="$readonly" 
            :disabled="$disabled" 
            :value="$attr"
            :extraAttributes="$extraAttributes" 
            :fieldwidth="$fieldwidth" />
        @break;
    @default
        <x-bs-form.input-counted 
            type="text" 
            id="{{ $fieldname }}"
            name="{{ $fieldname }}" 
            :hint="$hint" :label="$label" :placeholder="$placeholder" 
            :disabled="$disabled" :readonly="$readonly" :required="$required"  
            maxlength="190" 
            :value="$attr"
            :extraAttributes="$extraAttributes" 
            :fieldwidth="$fieldwidth"
        />
@endswitch
{!! $renderAfterField  !!}