<x-bs-dashboard>
    <h1 class="font-medium text-body text-xl md:text-2xl">Settings</h1>
    <div class="display-grid grid-cols-1 mt-6 lg:grid-cols-12 lg:grid-gap-x-8 lg:mt-8">
    @php( $hasMedia = 0 )
        <div class="col-span-1 lg:col-span-12">
            <x-bs-tabs id="edit-tabs">
                <x-bs-tabs.nav>
                    @foreach($groups as $group)
                        <x-bs-tabs.nav-item 
                            controls="page-{{ $group->group }}" 
                            :label="\App\Models\Setting::translateGroupName($group->group)"
                            :selected="( empty($selectedGroup) ? $loop->first : ($selectedGroup==$group->group) ) ? 'true' : 'false'" 
                        />
                    @endforeach
                </x-bs-tabs.nav>
                @foreach($groups as $group)
                    <x-bs-tabs.panel 
                        id="page-{{ $group->group }}" 
                        :selected="( empty($selectedGroup) ? $loop->first : ($selectedGroup==$group->group) ) ? 'true' : 'false'" 
                        >
                        <x-bs-card>
                            <x-bs-card.body>
                                @php( $selected = ($loop->first) ? 'true' : 'false')
                                <h2 class="font-semi-bold text-body text-lg">{{ Str::headline($group->group) }}</h2>
                                <form method="post" action="{{ $action }}">
                                    <div class="display-grid gap-y-5 grid-cols-1">
                                        @csrf
                                        <x-bs-form.input 
                                            name="bs4_group" 
                                            type="hidden" 
                                            :value="$group->group" 
                                        />
                                        @foreach($items as $item)
                                            @if($group->group == $item->group)
                                            @php( $section = $item->getOption('newsection',null)  )
                                                @if ($section !== null)
                                                    <div style='margin:1em 0px;'>
                                                    @if(!empty($section))
                                                        <x-bs-form.label>{{ $section }}</x-bs-form.label>
                                                    @endif
                                                    </div>
                                                @endif
                                                <div>
                                                @php( $required = $item->required ? 'required' : '' )
                                                @php( $label = $item->translateFieldName($item->title) . ($item->required ? ' *' : '') . ( empty($item->description) ? "" : "<br />(".$item->description.")") )
                                                @if(env('APP_DEBUG', false))
                                                    {{-- @php( $label.= " (#$item->id ".$item->group." / ".$item->slug.")" ) --}}
                                                @endif
                                                @switch($item->input)
                                                    @case('richtexteditor')
                                                        <x-bs-form.textarea 
                                                            richtexteditor 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug"
                                                            :label="$label"
                                                            :required="$required"
                                                            :value="$item->value ?? '<p>&nbsp;</p>'"
                                                        />
                                                        @break
                                                    @case('text-area')
                                                        <x-bs-form.textarea 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug"
                                                            :label="$label"
                                                            :required="$required" 
                                                            :value="$item->value"
                                                        />
                                                        @break
                                                    @case('choose-options')
                                                        @php( $options = $item->getOptionsArray() )
                                                        @if(empty($options))
                                                            <x-bs-form.input 
                                                                id="setting-{{ $item->slug }}" 
                                                                :name="$item->slug"
                                                                :label="$label" 
                                                                placeholder="" 
                                                                :required="$required" 
                                                                type="text" 
                                                                :value="$item->value ?? $item->default"
                                                            />
                                                        @else
                                                            <x-bs-form.select 
                                                                id="setting-{{ $item->slug }}"
                                                                :name="$item->slug"
                                                                :label="$label" 
                                                                placeholder=""
                                                                :required="$required" 
                                                                :options="$options" 
                                                                :selected="$item->value ?? $item->default ?? 0" />
                                                        @endif
                                                        @break
                                                    @case('data-list')
                                                        @php(  $options = $item->getOptionsArray() )
                                                        @if(empty($options))
                                                            <x-bs-form.input 
                                                                id="setting-{{ $item->slug }}" 
                                                                :name="$item->slug"
                                                                :label="$label" 
                                                                placeholder="" 
                                                                :required="$required" 
                                                                type="text" 
                                                                :value="$item->value ?? $item->default" 
                                                            />
                                                        @else
                                                            <x-bs-form.datalist 
                                                                id="setting-{{ $item->slug }}" 
                                                                :name="$item->slug"
                                                                :label="$label" 
                                                                placeholder="" 
                                                                :required="$required" 
                                                                :options="$options"
                                                                :selected="$item->value ?? $item->default" 
                                                            />
                                                        @endif
                                                        @break
                                                    @case('check-box')
                                                        <x-bs-form.check 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug"
                                                            :label="$label" 
                                                            value="1"
                                                            :checked="$item->value ?? $item->default ?? 0"
                                                        />
                                                        @break
                                                    @case('switch')
                                                        <x-bs-form.switch 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug" 
                                                            :label="$label" 
                                                            value="1"
                                                            :switch="$item->value ?? $item->default ?? 0" 
                                                        />
                                                        @break
                                                    @case('number')
                                                        <x-bs-form.input 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug"
                                                            :label="$label" 
                                                            placeholder="" 
                                                            :required="$required" 
                                                            type="number" 
                                                            step="any"
                                                            :value="$item->value ?? $item->default" 
                                                        />
                                                        @break
                                                    @case('money')
                                                        <x-bs-form.input 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug"
                                                            :label="$label" 
                                                            placeholder="" 
                                                            :required="$required" 
                                                            type="number" 
                                                            step="0.01" 
                                                            :value="$item->value ?? $item->default"
                                                        />
                                                        @break
                                                    @case('media')
                                                        @php( $hasMedia++ )
                                                        @php( $media = $item->value ?? $item->default )
                                                        <x-bs-form.media-single 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug" 
                                                            :label="$label"
                                                            placeholder="" 
                                                            :required="$required" 
                                                            type="text"
                                                            :value=$media  />
                                                        @break;
                                                    @case('media-gallery')
                                                        @php( $hasMedia++ )
                                                        @php( $media = $item->value ?? $item->default )
                                                        <x-bs-form.media-multiple 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug" 
                                                            :label="$label" 
                                                            placeholder="" 
                                                            :required="$required" 
                                                            type="text"  
                                                            :value=$media  
                                                        />
                                                        @break;
                                                    @case('date-time')
                                                        <x-bs-form.input 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug"
                                                            :label="$label" 
                                                            placeholder="" 
                                                            :required="$required" 
                                                            type="datetime-local" 
                                                            :value="$item->value ?? $item->default" 
                                                        />
                                                        @break;
                                                    @case('link-route:readonly')
                                                        <x-bs-form.label  :label="$label" /><br />
                                                        @php( $url = @$item->getRoutePath() )
                                                        @if(empty($url))
                                                            <div>The route specified &quot;{{ $item->value }}&quot;, is not valid.</div>
                                                        @else
                                                        <x-bs-button 
                                                            :href="$url">{{ $item->default ?? 'goto '.$url }}</x-bs-button>
                                                        @endif
                                                        @break;
                                                    @case('link:readonly')
                                                        @php( $value = str_replace('/{admin}/','/'.config('backslash4.adminPath','xxx').'/',$item->value) )
                                                        <x-bs-button :href="$value" :label="$label" />
                                                        @break;
                                                    @case('hidden')
                                                        @break    
                                                    @case('readonly')
                                                        <x-bs-form.input 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug" 
                                                            :label="$label" 
                                                            placeholder="" 
                                                            :required="$required" 
                                                            readonly="readonly"
                                                            disabled="disabled"
                                                            type="text" 
                                                            :value="$item->value ?? $item->default" 
                                                        />
                                                    @case('text')
                                                    @default
                                                        <x-bs-form.input 
                                                            id="setting-{{ $item->slug }}" 
                                                            :name="$item->slug"
                                                            :label="$label" 
                                                            placeholder="" 
                                                            :required="$required" 
                                                            type="text" 
                                                            :value="$item->value ?? $item->default" 
                                                        />
                                                @endswitch
                                                </div>
                                            @endif
                                        @endforeach
                                    </div>
                                    <x-bs-button 
                                        class="mt-5"
                                        text="Save changes"
                                        type="submit"
                                    />
                                </form>
                            </x-bs-card.body>
                        </x-bs-card>
                    </x-bs-tabs.panel>
                @endforeach
            </x-bs-tabs>
        </div>
        @if($hasMedia>0) {{-- because settings include some media --}}
            <x-bs-modal.library-modal />
        @endif
    </div>
</x-bs-dashboard>