@php
    $isTabbedModule = isset($submodule);
    if($isTabbedModule)
    {
        $tableName = ($appModel)::getTableName();
        $adminControllerInstance = new ($adminController);
        $adminRoute = $adminControllerInstance->adminRoute;
        $showAdminSearch = ($appModel)::showAdminSearch();
        $dropDownSearches = ($appModel)::getAdminSearchDropDowns();
        $showDropDownSearches = !empty($dropDownSearches);

        //$dropDownSearchLists = $dropDownSearchLists;  //[]; now passed by the controller
        if(empty($dropDownSearchLists) && !empty($dropDownSearches))
        {
            //boots and braces should never be called
            $dropDownSearchLists =[];
            foreach($dropDownSearches as $key => $text)
            {
                $dropDownSearchLists[$key]= ($appModel)::getAdminSearchDropDownList($key);
            }
        }

        $type =  Str::of(Str::replace('\\','/',$appModel))->basename();
        $showChildren = ($appModel)::showChildren();

        $hidden = ($appModel)::getHiddenFilters($submodule);
        foreach($hidden as $key => $parentfield)
            $hidden[$key] = $parentitem[$parentfield];

        $items = ($appModel)::adminListingWith(10,$hidden);

    } else
    {
        $parentitem=null;
        $submodule = CleverCherry\Backslash4\Backslash4::getDashboardFlatCMS()[Str::Studly($tableName)];
        $hidden =[];
    }

    if(!isset($submodule['name']))
    {
        $submodule['name'] = $tableName;
    }

    $title = $submodule['name'] ?? config('backslash4.cmsMenu.'.Str::Studly($tableName).'.name',null)  ?? Str::Headline($tableName);
    $slug = $submodule['slug'] ?? config('backslash4.cmsMenu.'.Str::Studly($tableName).'.slug', null);
    $adminPrefix = config('backslash4.adminPath', 'admin');

    $config = \Clevercherry\Backslash4\Backslash4::getDashboardConfig();
    $prefix = @$config['adminPath'] ?? 'admin';
@endphp

@if(false && $isTabbedModule)
    <div>
        <p>DEBUG:</p>
        <pre>{!! json_encode($submodule, JSON_PRETTY_PRINT) !!}</pre>
    </div>
@endif

@if (!$isTabbedModule)
    @php
        $breadcrumbs = [
            [
                'href' => '/' . $adminPrefix,
                'icon' => 'home',
            ],
            ($appModel)::getIndexBreadcrumbArray($adminPrefix, $slug, $title)
        ];
    @endphp

    <x-bs-breadcrumbs class="mb-4">
        <x-bs-breadcrumbs.list>
            @foreach ($breadcrumbs AS $item)
                <x-bs-breadcrumbs.item
                    :href="isset($item['href']) ? $item['href'] : null"
                    :icon="isset($item['icon']) ? $item['icon'] : null"
                    :text="isset($item['text']) ? $item['text'] : null"
                />
            @endforeach
        </x-bs-breadcrumbs.list>
    </x-bs-breadcrumbs>
@endif

<div class="display-flex flex-col items-start lg:flex-row lg:justify-between">
    <div class="display-flex flex-col">
        <h1 class="font-medium text-body text-xl md:text-2xl">{{ Str::headline($title) }}</h1>
        @php( $extra = ($appModel)::getExtraIndexHeaderView() )
        @if(!empty($extra))
                {!! $extra !!}
        @endif
        @if(isset($extraIndexHeaderView))
            {!! $extraIndexHeaderView !!}
        @endif
    </div>
    <div class="display-flex gap-3 items-start mt-4 lg:mt-0">
        @php( $export = ($appModel)::exportUrl() )
        @if( !empty($export) )
            <x-bs-button
                target="_blank"
                href="{{ route($adminRoute.'.export').str_replace(Request::url(), '', Request::fullUrl()) }}"
                icon="download-cloud"
                iconPosition="start"
                text="Export"
                theme="secondary"
                data-role="listing-export-btn"
                data-model="{{ $appModel }}"
            />
        @endif
        @if (($appModel)::showCMSAddNewButton())
            <x-bs-button 
                :href="($appModel)::cmsAddNewRouteUrl($adminRoute.'.create')"
                icon="plus"
                iconPosition="start"
                size="md"
                text="Add new" 
                theme="primary"
            />
        @endif
    </div>
</div>

<x-bs-card class="mt-6 lg:mt-8" data-role="{{ ($isTabbedModule) ? '' : 'main-module-container' }}">
    <x-bs-card.header>
        <x-bs-filters x-data="{ open: false }">
            <x-bs-filters.item data-filter="toggle">
                <x-bs-button
                    type="button"
                    text="Filters"
                    theme="secondary"
                    x-on:click="open = !open"
                />
            </x-bs-filters.item>
            <x-bs-filters.dropdown x-show="open">
                @if($showAdminSearch)
                    <x-bs-filters.item class="display-none lg:display-flex" data-role="search" data-filter="search">
                        <x-bs-index-search 
                            label="Search all {{ strtolower(@$submodule['name']) }}"
                            labelVisible="true"
                        />
                    </x-bs-filters.item>
                @endif
                @if($showDropDownSearches)
                    <x-bs-filter-search
                        :isTabbedModule=$isTabbedModule
                        :searches=$dropDownSearches 
                        :lists=$dropDownSearchLists 
                        :model=$appModel
                        :hidden="$hidden"
                    />
                @endif
            </x-bs-filters.dropdown>
            @if($showAdminSearch || $showDropDownSearches)
                <x-bs-js.remove-url-params />
            @endif
        </x-bs-filters>
    </x-bs-card.header>
    <div class="overflow-scroll" data-role="index-table-container" @if(!$isTabbedModule) data-ajax-href="{{ ($appModel)::getDataAjaxUrl($adminRoute) }}" @endif>
        @if( !$isTabbedModule) {{-- tabbed version will be loaded by ajax after page load time and URLs --}}
            @include('backslash4::admin.generic.no-dashboard.table', ['appModel'=>$appModel])
        @endif
    </div>
    <x-bs-placeholder.table />
</x-bs-card>

@if(isset($extraIndexFooterView))
    {!! $extraIndexFooterView !!}
@endif
@php( $extra = ($appModel)::getExtraIndexFooterView() )
@if(!empty($extra))
    {!! $extra !!}
@endif

<x-bs-modal.delete-post-item 
    :tableName="$tableName"
    :isTabbedModule=$isTabbedModule
    :parentitem=$parentitem
/>