@props([
    'id' => null,
    'module' => null,
    'message' => null,
    'item' => null
])
@php
    $name = 'item';
    if(!empty($module)) {
        $name = Str::singular($module);
    } elseif(!empty($item)) {
        $name = Str::singular(@$item->getTableName() ?? 'item');
    }

    $title = 'Duplicate ' . $name;

    // test if it is PHQ3 ie Development model exists and the table/item has the field 'development'
    $hasDevelopment = class_exists('\App\Models\Development') 
                    && isset($item->development);

    $max = config('backslash4.maxDuplicates', 5);
    // if you want to get it from somewhere else
    // put this function in the ($model)->getMaxDuplicates()
    if(!empty($item) && method_exists($item, 'getMaxDuplicates')) {
        $max = $item->getMaxDuplicates();
    }
    
    $placeholder="e.g. 4 (max {$max})";
@endphp


<x-bs-modal id="duplicate-post-item-modal" size="md" data-role="duplicate-post-item-modal">
    <x-bs-modal.header
        direction="row"
        :icon="[
            'icon' => 'folder-plus',
            'theme' => 'primary'
        ]"
        :$title
        :text="'Please enter the number of times you would like to duplicate this ' . $name"
    />
    <form action="{{ route('admin.' . $module . '.duplicate', ['id' => $id]) }}" method="get">
        <x-bs-modal.content>
            <x-bs-form.input
                name="amount"
                id="amount"
                type="number"
                :$placeholder
                data-role="monitor-max"
                :$max
                min="0"
            />
            {{-- test if it is PHQ3 ie Development model exists --}}
            {{-- ideally at some point we should render this from a function in a model/$item --}}
            @if($hasDevelopment)
            <x-bs-form.select 
                name="development"
                label="Select Development" 
                :options="Development::listingOptions()"
             />
             @endif
        </x-bs-modal.content>
        <x-bs-modal.actions>
            <x-bs-button 
                size="lg"
                id="duplicate-ok-item-modal"
                text="Duplicate"
                theme="primary"
                type="submit" 
            />
            <x-bs-button
                size="lg"
                text="Cancel"
                theme="secondary"
                type="button"
                data-a11y-dialog-hide
                aria-label="Close dialog" 
            />
        </x-bs-modal.actions>
    </form>
</x-bs-modal>
<script>
    const bs4_MonitorMax = (event) => {
        const max = Number(event.target.getAttribute('max'));
        const min = Number(event.target.getAttribute('min'));
        if(event.target.value>max) {
            event.target.value=max;
        }
        if(event.target.value<min) {
            event.target.value=min;
        }
    }
    document.addEventListener('DOMContentLoaded', (event)=>{
        document.querySelectorAll('input[data-role="monitor-max"]').forEach((inputElement) =>{
            inputElement.addEventListener('input', bs4_MonitorMax);
        })
    })
</script>