@props([
    'id' => 'file-picker-modal',
    'folder' => 'misc',
    'filerequirements' => ['PDF, DOC, DOCX, XLS, XLSX, ODT, ODS', '.pdf, .doc, .docx, .xls, .xlsx, .odt, .ods'],
])

<x-bs-modal id="{{ $id }}" size="xl">
    <x-bs-modal.header
        direction="row"
        :icon="[
            'icon' => 'file-plus',
            'theme' => 'primary'
        ]"
        title="Files"
        text="View and upload new files to the website."
    />
    <x-bs-modal.content class="px-0 py-0">
        <x-bs-files
            :folder=$folder 
            :filerequirements=$filerequirements 
            {{ $attributes }} 
        />
    </x-bs-modal.content>
</x-bs-modal>

<x-bs-modal.add-folder />
