@props([
    'tableName' => 'null',
    'title' => null,
    'message' => null,
    'itemname' => null,
])
@php
    if($itemname==null)
        $itemname = Str::headline(Str::Singular($tableName));

    if($title==null)
        $title = 'Delete '. $itemname;

    if($message==null)
        $message = "Are you sure you want to delete this " . strtolower($itemname) ."? This action cannot be undone.";
@endphp

<x-bs-modal id="delete-post-item-{{ $tableName }}" data-role="delete-post-item-modal" size="sm">
    <x-bs-modal.header
        :icon="[
            'icon' => 'trash',
            'theme' => 'error'
        ]"
        title="{{ $title }}"
        text="{!! $message !!}"
    />
    <x-bs-modal.actions>
        <x-bs-button
            size="lg"
            text="Cancel"
            theme="secondary"
            type="button"
            data-a11y-dialog-hide
            aria-label="Close dialog" 
        />
        <x-bs-button 
            size="lg"
            text="Delete"
            theme="error"
            type="button" 
            data-action="delete-post-item" 
        />
    </x-bs-modal.actions>
</x-bs-modal>