@props([

])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'media-library',
        ])
@endphp

<x-bs-tabs data-view="modal" id="media-tabs">
    <x-bs-tabs.nav>
        <x-bs-tabs.nav-item controls="modal-media-library" label="Library" selected="true" />
        <x-bs-tabs.nav-item controls="modal-media-upload" label="Upload" selected="false" />
    </x-bs-tabs.nav>

    <x-bs-tabs.panel id="modal-media-upload" selected="false">
        <div class="px-6 py-8">
            <x-bs-form.dropzone class="sr-only" icon="upload" id="media-upload" 
                        requirements="{{ \App\Models\MediaManager::getFileRequirements() }}" 
                        accept="{{ \App\Models\MediaManager::getFileAccept() }}" />
            <div class="file-queue" data-role="file-queue">
                <div id="hiddenFileQueueItem" class="sr-only"> {{-- so thatJavaScript can duplicate the object for uploads --}}
                    <x-bs-file-queue.item />
                </div>
            </div>
        </div>
    </x-bs-tabs.panel>
    
    <x-bs-tabs.panel id="modal-media-library" selected="true">        
        <div class="media" data-view="modal">
            <div class="media__library">
                @php
                    $dirs = \App\Models\MediaManager::getUploadDirectories('Select a folder');
                @endphp
                <div class="form-group w-full">
                    <div style="width:74%">
                    <x-bs-form.select
                        id="uploadDirectory" 
                        label="Select a folder" 
                        :options="$dirs" 
                        firstoption="readonly disabled selected" 
                    />
                    </div>
                    <div style="width:24%;margin-left:2%;">
                    <x-bs-media.popup-search 
                        label='Search all Media <small style="color:grey;">(all words)</small>'
                        labelVisible="true"
                    />
                    </div>
                </div>
                <div class="media__library-items" data-role="media-items">

                </div>
            </div>
            <div class="media__sidebar">
                <div class="media__sidebar-section">                    
                    <div class="media-item">
                        <div class="media-item__inner">
                            <img class="media-item__preview" src="" data-role="sidebar-thumbnail" />
                        </div>
                        <div class="media-placeholder__inner" data-role="sidebar-placeholder">
                            <x-bs-featured-icon 
                                data-action="add-media"
                                icon="image-add"
                                size="lg"
                                theme="primary"
                                variant="circle"
                            />
                        </div>
                    </div>
                    <p class="font-medium text-sm text-gray-700" data-role="sidebar-file-name">file-name.jpg</p>
                    <p class="font-regular mt-1 text-sm text-body-tertiary">Dimensions: <span data-role="sidebar-file-dimensions">400 x 400</span></p>
                </div>
                <div class="media__sidebar-section">
                    <x-bs-form.input 
                        data-dialog-id="alt" 
                        label="Alt text"
                    />
                </div>
                <div class="media__sidebar-section">
                    <x-bs-button 
                        text="Update media"
                        theme="primary"
                        type="button"
                        data-a11y-dialog-hide="save-media"
                    />
                    <x-bs-button 
                        text="Reset media"
                        theme="primary"
                        type="button"
                        data-a11y-dialog-hide="reset-media"
                    />
                    <x-bs-button 
                        text="Cancel"
                        theme="secondary"
                        type="button"
                        data-a11y-dialog-hide="cancel-save-media"
                    />
                </div>
            </div>
            
        </div>
        <!-- <div class="media-library__footer">
            <x-bs-button 
                text="Update media"
                type="button"
                width="full" 
            />
        </div> -->
    </x-bs-tabs.panel>
</x-bs-tabs>
