@props([
    'columnSpan' => [
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ],
    'rowSpan' => [
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ]
])

@php    
    $columnSpan = array_merge([
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ], $columnSpan);
    
    $rowSpan = array_merge([
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ], $rowSpan);

    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'col-span-' . $columnSpan['xs'] => isset($columnSpan['xs']),
            'row-span-' . $rowSpan['xs'] => isset($rowSpan['xs']),
            'sm:col-span-' . $columnSpan['sm'] => isset($columnSpan['sm']),
            'sm:row-span-' . $rowSpan['sm'] => isset($rowSpan['sm']),
            'md:col-span-' . $columnSpan['md'] => isset($columnSpan['md']),
            'md:row-span-' . $rowSpan['md'] => isset($rowSpan['md']),
            'lg:col-span-' . $columnSpan['lg'] => isset($columnSpan['lg']),
            'lg:row-span-' . $rowSpan['lg'] => isset($rowSpan['lg']),
            'xl:col-span-' . $columnSpan['xl'] => isset($columnSpan['xl']),
            'xl:row-span-' . $rowSpan['xl'] => isset($rowSpan['xl']),
            'xxl:col-span-' . $columnSpan['2xl'] => isset($columnSpan['2xl']),
            'xxl:row-span-' . $rowSpan['2xl'] => isset($rowSpan['2xl']),
        ]);
@endphp

<div {{ $attributes }}>
    {{ $slot }}
</div>