@props([
    'header' => true,
    'sidebar' => true,
    'title' => 'CleverCherry CMS Dashboard Backslash4'
])

<!DOCTYPE html>
<html lang="en" x-data data-theme="light" :data-theme="$store.global.theme">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="csrf-token" content="{{ csrf_token() }}" />
        <title>{{ $title }}</title>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

        @vite(['resources/scss/admin.scss'])

        <style>
            [x-cloak] {
                display: none;
            }
        </style>

        <script>
            var theme = localStorage.getItem("_x_theme");
            document.documentElement.setAttribute('data-theme', JSON.parse(theme));
        </script>
    </head>
    @if (\Session::has('bs4response'))
        @php
            $bs4response = session('bs4response');
            $bs4responseTheme = 'primary';
            
            switch (@$bs4response['status']) {
                case ('ERROR'):
                    $bs4responseTheme = 'error';
                    break;
                case ('DELETED'):
                    $bs4responseTheme = 'error';
                    break;
                case ('OK'):
                    $bs4responseTheme = 'success';
                    break;
                default:
                    $bs4responseTheme = 'primary';
                    break;
            }
        @endphp
    <body
        x-data
        x-init="$nextTick(() => {
                $dispatch('alert', {
                    type: '{{ $bs4responseTheme }}',
                    title: '{{ @$bs4response['title'] }}',
                    message: '{{ @$bs4response['message'] }}',
                })
            }
        )"
    >
    @else
    <body>
    @endif
        @if ($sidebar)
            <x-bs-admin.sidebar/>
        @endif
        @if ($header)
            <x-bs-admin.header />
        @endif
        {{ $slot }}
        <script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>
        @vite(['resources/js/admin.js'])
 
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.store('global', {
                    theme: Alpine.$persist('light'),
                    menu: false,
        
                    toggleTheme: function() {
                        if (this.theme === 'light') {
                            this.theme = 'dark';
                        } else {
                            this.theme = 'light';
                        }
                    },
                    toggleMenu: function() {
                        this.menu = !this.menu;
                    }
                })
            })
        </script>

        <x-bs-notifications />
    </body>
</html>