@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'options' => [],
    'type' => 'text',
    'firstoption' => '',
    'selected' => '',
    'required' => '',
    'hint' => '',
    'allowedValues' => '3'
])

@php
    $attributes = $attributes
    ->merge([
    ])
    ->class([
    ]);
@endphp

<x-bs-form.group class="{{ $group['class'] }}">
    <x-bs-form.label :label=$label :for="$id" :hint=$hint />
    <div class="tag-select" data-show-results="false">
        <input data-role="tag-select-values" {{ $required }}  type="hiddedn" {{ $attributes }} {{ $id  ? "id=$id" : "" }} list="bs4-datalist-{{ $id ?? $attributes->name }}" value="{{ $selected }}" />
        <div class="tag-select__input">
            <input class="tag-select__input-search" type="text">
        </div>
        <div class="tag-select__options">
            <x-bs-menu>
                <x-bs-menu.scroller>
                    <x-bs-menu.group>
                        @foreach ($options as $value => $label)
                            <x-bs-menu.item
                                data-role="tag-select-option"
                                data-value="{{ $value }}"
                                text="{{ $label }}"
                                type="button"
                            />
                        @endforeach
                    </x-bs-menu.group>
                </x-bs-menu.scroller>
            </x-bs-menu>
        </div>
    </div>
</x-bs-form-group>