@props([
	'title' => 'Vimeo Video',
	'embedId' => null,
	'width' => 640,
	'height' => 360,
	'frameBorder' => 0,
	'allow' => [], // autoplay; fullscreen; picture-in-picture
	'allowFullScreen' => true,
])

@if(! empty($embedId))
<iframe
	title="{{ $title }}"
	src="https://player.vimeo.com/video/{{ $embedId }}"
	width="{{ $width }}"
	height="{{ $height }}"
	frameborder="{{ $frameBorder }}"
	allow="{{ implode(';', $allow) }}"
	@if($allowFullScreen)
	allowfullscreen
	@endif
	/>
</iframe>
@endif