@php
    $newItem = last(request()->segments()) === 'create';
    $config = \Clevercherry\Backslash4\Backslash4::getDashboardConfig();
    $adminPrefix = @$config['adminPath'] ?? 'admin';

    if(empty(@$bs4tab))
        $bs4tab =  session('bs4tab', '');
    if(empty($bs4tab))
        $bs4tab = Request()->bs4tab;
    
    $bs4tab = empty($bs4tab) ? '' : strtolower($bs4tab);
@endphp

<main id="maincontent">
    @if(! empty($item->getCmsBreadcrumbs()))
    <x-bs-breadcrumbs class="mb-4">
        <x-bs-breadcrumbs.list>
            <x-bs-breadcrumbs.item
                href="/{{ $adminPrefix }}"
                icon="home"
            />
            @foreach($item->getCmsBreadcrumbs() AS $title => $link)
                <x-bs-breadcrumbs.item
                    href="{{ $link }}"
                    text="{{ $title }}"
                />
            @endforeach
        </x-bs-breadcrumbs.list>
    </x-bs-breadcrumbs>
    @endif
    <form method="post" action="{{ $action }}" data-class="{{ $item->basename() }}">
        @csrf
        @if( false ) {{-- dev info --}}
                <div>fillable: {{ json_encode($item->getFillable())}}</div>
                <div>guarded: {{ json_encode($item->getGuarded()) }}</div>
                <div>action="{{ $action }}"</div>
        @endif
        <x-bs-grid :columns="['xs' => '1', 'lg' => '3']" :gap="['xs' => '4', 'lg' => '6']">
            <x-bs-grid.item :columnSpan="['xs' => '1', 'lg' => '2']">
                <x-bs-tabs id="edit-tabs" x-refs="tabs">
                    @php
                        $hasMedia = $item->hasMediaCount();
                        $editTabs = $item->getEditTabs();
                    @endphp
                    <x-bs-tabs.nav>
                        @foreach ($editTabs as $tab => $tabName)
                            <x-bs-tabs.nav-item 
                                controls="page-{{ $tab }}"
                                :label="ucfirst($tabName)" 
                                :selected="( ($loop->first && empty($bs4tab)) || ($bs4tab==strtolower($tabName)) ) ? 'true' : 'false'" 
                            />
                        @endforeach
                        @php( $moduleSettings = $item->getDashBoardSettings() )
                        @if( isset($moduleSettings['subMenu_modules'])  && ($moduleSettings['subMenu_modules']=='tabs') )
                            @foreach($moduleSettings['subMenu'] as $key => $submodule)
                                @if(isset($submodule['name']))
                                    <x-bs-tabs.nav-item 
                                        controls="module-{{ $key }}" 
                                        :label="$submodule['name']" 
                                        :selected="($bs4tab==strtolower($submodule['name']) ? 'true' : 'false')" 
                                    />
                                @endif
                            @endforeach
                        @endif
                    </x-bs-tabs.nav>

                    @foreach($editTabs as $tab => $tabName)
                        <x-bs-tabs.panel id="page-{{ $tab }}" 
                                :selected="( ($loop->first && empty($bs4tab)) || ($bs4tab==strtolower($tabName)) ) ? 'true' : 'false'" >
                            <x-bs-accordion>
                                <details class="accordion__item" open>
                                    <x-bs-accordion.header :expand="$newItem ? false : true">
                                        {{ ucfirst($tabName) }}
                                    </x-bs-accordion.header>
                                    <div class="accordion__item-content">
                                        <div class="display-flex flex-col gap-y-5">
                                            <x-bs-fieldset.custom-content :$item :$tab :fieldset="$tab" />
                                            @foreach ($item->getFillable() as $fieldName)
                                            @if ($item->getFieldTab($fieldName) == $tab)
                                                    @php ($section = $item->isBreakBeforeField($fieldName))
                                                    @if (!empty($section) )
                                                                </div>
                                                            </div>
                                                        </details>
                                                        <details class="accordion__item" @if (!$newItem)  @else open @endif>
                                                            <x-bs-accordion.header :expand="$newItem ? false : true">
                                                                {{ ($section === true ? '' : $section ) }}
                                                            </x-bs-accordion.header>
                                                            <div class="accordion__item-content">
                                                                <div class="display-flex flex-col gap-y-5">
                                                    @endif
                                                    <x-bs-form.auto-generic 
                                                        :item=$item 
                                                        :fieldname=$fieldName 
                                                    />
                                                    @php ($section = $item->isBreakAfterField($fieldName))
                                                    @if (!empty($section) )
                                                                </div>
                                                            </div>
                                                        </details>
                                                        <details class="accordion__item" @if (!$newItem) @else open @endif>
                                                            <x-bs-accordion.header :expand="$newItem ? false : true">
                                                                {{ ($section === true ? '' : $section ) }}
                                                            </x-bs-accordion.header>
                                                            <div class="accordion__item-content">
                                                                <div class="display-flex flex-col gap-y-5">
                                                                    <x-bs-fieldset.custom-content :$item :$tab :fieldset="$section" />
                                                    @endif
                                                @endif
                                            @endforeach
                                        </div>
                                    </div>
                                </details>
                            </x-accordion>
                            @if($item->hasBlocks() && $loop->first)
                                <x-bs-blocks.blockeditor 
                                    :item=$item 
                                />
                            @endif
                        </x-bs-tabs.panel>
                    @endforeach
                    @php( $moduleSettings = $item->getDashBoardSettings() )
                        @if( isset($moduleSettings['subMenu_modules'])  && ($moduleSettings['subMenu_modules']=='tabs') )
                            @foreach($moduleSettings['subMenu'] as $key => $submodule)
                                @if(isset($submodule['name']))
                                @php( $singular = Str::singular($key) )
                                <x-bs-tabs.panel 
                                    id="module-{{ $key }}" 
                                    :selected="($bs4tab==strtolower($submodule['name'])) ? 'true' : 'false'" >
                                    <div data-role="module-index-container" data-module="{{ $key }}"
                                        data-href="{{ route('admin.'.strtolower($key).'.index.ajax' ) }}"> 
                                        @include('backslash4::admin.generic.no-dashboard.index', 
                                                ['submodule' => $submodule,
                                                'appModel'  => 'App\\Models\\'.$singular,
                                                'adminController' => 'App\\Http\\Controllers\\Admin\\'.Str::singular($key).'Controller',
                                                'parentitem' => $item ])
                                    </div>
                                </x-bs-tabs.panel>
                                @endif
                            @endforeach
                        @endif
            </x-bs-tabs>
        </x-bs-grid.item>
        @if(!empty($bs4tab))
        {{-- This script forces the tab to be the one remembered/required for the AlpineJS controls --}}
        <script>
            document.addEventListener("alpine:initialized", () => {
                let tab = document.querySelector('[aria-controls=page-{{ ucfirst($bs4tab) }}]');
                if(tab==null)
                    tab = document.querySelector('[aria-controls=module-{{ ucfirst($bs4tab) }}]');
                if(tab!=null)
                {   // found it so select/click it
                    tab.dispatchEvent( new MouseEvent("click", 
                                                { bubbles: true,
                                                  cancelable: true,
                                                  view: window })
                                        );
                }
            });
        </script>
        @endif
        <x-bs-grid.item class="lg:pt-20" :columnSpan="['xs' => '1']">
            <x-bs-publisher>
                @foreach($item->getFillable() as $fieldName)
                    @if($item->getFieldTab($fieldName) == 'sidebar')
                        <x-bs-form.auto-generic 
                            :item=$item 
                            :fieldname=$fieldName 
                        />
                    @endif                        
                @endforeach                    
                @php( $sidebarExtra = @$item->getExtraSidebarView() )
                @if(!empty($sidebarExtra))
                    {!! $sidebarExtra !!}
                @endif
                <div class="display-grid gap-y-4 grid-cols-1">
                    <div class="display-grid gap-y-4 grid-cols-1">
                        @if($item->id && $item->canDuplicate())
                            <x-bs-button
                                theme="secondary"
                                text="Duplicate"
                                data-duplicate-url="{{ route('admin.' . $item->getTable() . '.duplicate',['id'=>$item->id]) }}" 
                                data-a11y-dialog-show="duplicate-post-item-modal"
                            />
                        @endif
                        <x-bs-button 
                            type="submit"
                            text="Save"
                            theme="primary"
                        />
                        <x-bs-button 
                            href="{{ $cancel }}"
                            text="Cancel"
                            theme="secondary"
                        /> 
                </x-bs-publisher>
            </x-bs-grid.item>
        </x-bs-grid>
    </form>
</main>
@if($item->id && $item->canDuplicate())
<x-bs-modal.duplicate-post-item
    id="{{ $item->id }} "
    module="{{ $item->getTable() }}"
    :$item
/>
@endif
@if($item->hasBlocks() || ($hasMedia>0)) {{-- because if it has block editor or media only once --}}
    <x-bs-modal.library-modal />
@endif