@props([
    'file' => [],
    'href' => false
])
@php
    if(!empty($file))
    {
        $title = @$file['title'] ?? basename(@$file['url'] ?? @$file['filename']);
        $hidden = "";

    } else
    {
        $title = '';
        $hidden = 'display-none';
    }

    $link = '';
    if($href)
    {
        $link = @$file['url'];
        if(!empty($link))
        {
            if(!Str::startsWith($link, 'http'))
            {
                $link = \App\Models\MediaManager::getStoragePath($link);
                $link = Storage::disk('s3')->temporaryUrl($link, now()->addMinutes(15));
            }
        }
    }
@endphp
<x-bs-tag.dismissable
    action="delete-file-tag" 
    :class="$hidden"
    icon="file"
    :label="$title ? $title : 'file'"
    :data-name="@$file['filename']"
    :href=$link
/>
