<?php

namespace Clevercherry\Backslash4\Traits;

use Illuminate\Support\Facades\Storage;

trait metaTrait
{
	/**
	 * Returns the meta description for given item, this can
	 * be overridden in the application model
	 * 
	 * @return string
	 */
	public function getMetaDescription() : string
	{
		if(! empty($this->seo_description)) {
			return $this->seo_description;
		}

		if(! empty($this->meta_description)) {
			return $this->meta_description;
		}
        
        return \App\Models\Setting::getSetting('meta_description', $this->getNameTitle());
	}

	/**
	 * Returns the meta title for given item, this can
	 * be overridden in the application model
	 * 
	 * @return string
	 */
	public function getMetaTitle() : string
	{
		if(! empty($this->seo_title)) {
			return $this->seo_title;
		}

		if(! empty($this->meta_title)) {
			return $this->meta_title;
		}
		if(! empty($this->seo_name)) {
			return $this->seo_name;
		}

		if(! empty($this->meta_name)) {
			return $this->meta_name;
		}
        
        return \App\Models\Setting::getSetting('meta_title', $this->getNameTitle());
	}

	/**
	 * Returns the meta thumbnail for given item, this can
	 * be overridden in the application model
	 * 
	 * @return string
	 */
	public function getMetaThumbnail() : string
	{
		$firstMedia = $this->getFirstMedia('media_thumbnail');


		if($firstMedia) {
			return $firstMedia->originalUrl();
		}

		return Storage::url('images/defaults/thumbnail.png');
	}
}
