
<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Models\Setting;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $setting = New Setting();
        $setting->title = 'BS4 Network API Key';
        $setting->slug = 'bs4_network_api_key';
        $setting->group = 'BS4 Network API';
        $setting->input = 'text';
        $setting->order = 95010;
        $setting->value = '';
        $setting->save();

        $setting = New Setting();
        $setting->title = 'BS4 Network API Secret';
        $setting->slug = 'bs4_network_api_secret';
        $setting->group = 'BS4 Network API';
        $setting->input = 'text';
        $setting->order = 95020;
        $setting->value = '';
        $setting->save();
        
        // optional as all sites will use the default
        // you may want to set this up on local to fire elsewhere
        $setting = New Setting();
        $setting->title = 'BS4 Network API Host URL';
        $setting->slug = 'bs4_network_api_host_url';
        $setting->group = 'BS4 Network API';
        $setting->description = 'leave blank to fire the API at CCHUB';
        $setting->input = 'text';
        $setting->order = 95030;
        $setting->value = ''; // 'https://cchub.clevercherry.com/api/v1';
        $setting->save();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        setting::whereIn('slug', ['bs4_network_api_key', 'bs4_network_api_secret', 'bs4_network_api_host_url'])->delete();
    }
};
