@php
    // without a props field all parameters come through as variables
    
@endphp
@foreach($searches as $field_name => $field_text)
    @php
        if(isset($hidden[$field_name]))
            $value = $hidden[$field_name];
        else
            $value = (Request()->$field_name ?? Session::get(($model)::getFieldSessionKey($field_name)) ?? '');
        
        $type = ($model)::getAdminSearchDropDownType($field_name);
    @endphp
    @if($field_name=="@reset")
        <x-bs-filters.item class="{{ isset($hidden[$field_name]) ?  ' sr-only' : '' }}" data-filter="reset">
            <x-bs-button
                type="button"
                data-role="index-search-reset"
                theme="secondary"
                text="{{ isset($hidden[$field_name]) ? '' : $field_text }}"
            />
        </x-bs-filters.item>
    @else
        @if(isset($hidden[$field_name]))
            {{-- if it's hidden it will have only one value, no point rendering a switch or anything else --}}
            <input 
                type="hidden"
                name='' {{-- because they must not be part of a form submission when inside another model --}}
                id="index-search-{{ $field_name }}" 
                label=""
                data-role="index-search" 
                data-field-name="{{ $field_name }}"
                data-reset="0"
                value="{{ $value }}"
            />
        @else
            <x-bs-filters.item>
                @switch($type)
                    @case('date')
                        <x-bs-form.input 
                            type="date" 
                            name="" {{-- because they must not be part of a form submissionm when inside another model --}}
                            id="index-search-{{ $field_name }}" 
                            label="{{ isset($hidden[$field_name]) ? '' : $field_text }}" 
                            data-role="index-search" 
                            data-field-name="{{ $field_name }}"
                            data-reset="1"
                            :value=$value
                            step="1"
                        />
                    @break
                @default {{-- default is the select drop down --}}
                    <x-bs-form.select 
                        id="index-search-{{ $field_name }}" 
                        name=""
                        label="{{ isset($hidden[$field_name]) ? '' : $field_text }}" 
                        :options=$lists[$field_name] 
                        :selected=$value 
                        data-role="index-search" 
                        data-field-name="{{ $field_name }}"
                        data-reset="1"
                    />
                @endswitch
            </x-bs-filters.item>
        @endif
    @endif
@endforeach