<?php

namespace Clevercherry\Backslash4\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Hash;
use Laravel\Sanctum\HasApiTokens;
use Clevercherry\Backslash4\Traits\baseModel;
use Clevercherry\Backslash4\Traits\journeyTracker;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use scopeActive, ColumnFillable, baseModel;
    use journeyTracker;
    //protected $fillable = [ 'name', 'email', 'password', ];

    public const  STATE_INACTIVE = 0;
    public const  STATE_ACTIVE   = 1;

    /**
     * The attributes that should be hidden for serialization.
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * Override bs4\Model as users do not have blocks
     */
    public function hasBlocks()
    {
        return false;
    }

    /**
    * return an array widget info
    * @return Array of widget info for display on the admin dashboard
    */
    public static function getDashboardWidgets()
    {
        $widgets=[];

        // $widgets[]=['type'=>'bs-dashboard-widget.info',
        //             'heading'=>"No. of Users",
        //             'text'=> 'Active '.self::active()->count('id').'<br>'
        //                     .'All '.self::count('id'),
        //           ];
        return $widgets;
    }

    //default no front end routes -- override in your app if required
    public static function getFrontEndRoute($default, $is_index=false) : String | null
    {
        return null;
    }

    /**
     * Generate a verification hash
     */
    public function getVerificationHash() : string
    {
        return Hash::make($this->email.$this->created_at.$this->id);
    }
    /**
     * checkec whether a provide dhash matches the above
     */
    public function checkVerificationHash($hash) : bool
    {
        return Hash::check($this->email.$this->created_at.$this->id, $hash);
    }

    /**
     * add the records {id} and {hash} to a route
     */
    public function getVerificationRoute($route) : string
    {
        return route($route, ['id'=>$this->id, 'hash'=>$this->getVerificationHash()]);
    }

    
}