<?php

namespace Clevercherry\Backslash4\Models;

use App\Http\Controllers\OrderController;
use App\Models\Address;
use Illuminate\Support\Str;
use Illuminate\Support\Carbon;

class Order extends Model
{
    use scopeActive;

    public const  STATE_INACTIVE = 0;
    public const  STATE_ACTIVE   = 1;

    public const  ACCOUNT_GUEST  = -1;

    public const  STATUS_OPEN      = 0;
    public const  STATUS_PAID      = 2;
    public const  STATUS_SHIPPED   = 4;
    public const  STATUS_REFUNDED  = 64;
    public const  STATUS_CANCELLED = 128;
    public const  STATUS_CLOSED    = 256;

    /**
     * Override default
     */
    public function hasBlocks()
    {
        return false;
    }

    /**
     * return a list of categories or types for field selection
     */
    public function getChooseOptions($field_name)
    {
        $list = [];

        if(Str::endsWith($field_name, '_address'))
        {
            $list[0] = 'Select a '. Str::headline($field_name);
            $list[-1]="+ Add a new Address...";
        
            $items = Address::getAddresses($this->id, ($field_name=='shipping_address') ? Address::TYPE_SHIPPING : Address::TYPE_BILLING);
            foreach($items as $item)
                $list[$item->id] = $item->getShortName();

            //see if the actual address on this order is in the supplied list
            $notfound=null;
            if(($field_name=='shipping_address') && !isset($list[$this->shipping_address]))
            {   $notFound = $this->shipping_address;
            } else if(($field_name=='billing_address') && !isset($list[$this->billing_address]))
            {   $notFound = $this->billing_address;
            }
            if($notfound!=null)
            {   $addr = Address::where('id', $notfound);
                if(!empty($addr))
                    $list[$notfound] = 'Old Address: '.$addr->getShortName();
                else
                    $list[$notfound] = 'Deleted Address #'.$notfound;
            }
        }
            
        return $list;
    }

    public function getShippingAddress()
    {
        return Address::where('id', $this->shipping_address)->first();
    }
    public function getBillingAddress()
    {
        return Address::where('id', $this->billing_address)->first();
    }

    public static function getCartOrder()
    {
        $cart = OrderController::getCalcCart();
        return self::where('id', $cart['id'])->first();
    }

    /**
    * return an array widget info
    * @return Array of widget info for display on the admin dashboard
    */
    public static function getDashboardWidgets()
    {
        $widgets=[];

        $widgets[]=['type'=>'bs-dashboard-widget.info',
                    'heading'=>"No. of Orders",
                    'text'=> 'Active '.self::active()->count('id').'<br>'
                            .'All '.self::count('id'),
                    'widget-order' => 1500
                  ];

        $date = Carbon::today()->subDays(7);
        $orders = self::where('created_at','>=',$date)->count('id');
        $date2 = Carbon::today()->subDays(14);
        $orders2 = self::where('created_at','>=',$date2)->where('created_at','<',$date)->count('id');
        if($orders2==0)
            $pc = ($orders==0) ? 0 : 100;
        else
            $pc = round(100*($orders/$orders2) - 100,2);

        $widgets[]=['type'=>'bs-dashboard-widget.metric',
                  'heading'=>"Orders",
                  'figure'=> str($orders),
                  'change'=> $pc."%",
                  'trend'=> ($pc>0) ? "increase" : "decrease",
                  'period'=>"last 7 days",
                  'widget-order' => 1510
                ];
        
        return $widgets;
    }

    /**
     * Adds model description text under the main <h1> tag.
     * 
     * @return String content to be displayed under the the index page heading.
     */

    public static function getExtraIndexHeaderView()
    {
        return '<p class="mt-1 text-body-tertiary">Review and manage recent orders.</p>';
    }
}