<?php

namespace Clevercherry\Backslash4\Models;

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;

trait ColumnFillable
{
    public $isfillabled = false;

    public function getFillable()
    {
        if(app()->runningInConsole() && (! isset($this->fillable) || empty($this->fillable))) {
            return $this->setDynamicFillable();
        }

        return $this->fillable;
    }

    /**
     * Use this to set / get the $fillable array dynamically on a model
     * Can be overridden in the application model if needed
     * 
     * @return array
     */
    public function setDynamicFillable() : array
    {
        if(! $this->isfillabled)
        {
            $fields =  Schema::getColumnListing($this->getTable());
            foreach($this->guarded as $item)
            {
                if(isset($fields[$item]))
                    unset($fields[$item]);
            }
            $this->fillable = $fields;
        }

        return $this->fillable;
    }

    /**
     * @deprecated - included for backwards compatibility
     * use $this->setDynamicFillable() going forwards
     * 
     * @return array
     */
    public function getFillableForEditTabs()
    {
        return $this->setDynamicFillable();
    }
}