<?php

namespace Clevercherry\Backslash4\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

use Illuminate\Support\Facades\Schema;
use Clevercherry\Backslash4\Traits\OnTenant;
use Illuminate\Support\Str;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\Block; //has to be the app version so that functions are overridable
use Clevercherry\Backslash4\Backslash4;
use Clevercherry\Backslash4\Traits\baseModel;
use PhpParser\Node\Expr\Cast\String_;

class Admin extends Authenticatable
{
    use baseModel;
    use scopeActive, OnTenant;

    public const  STATE_INACTIVE = 0;
    public const  STATE_ACTIVE   = 1;

    // override or use trait ColumnFillable in your app model
    public $fillable = [ 'userName', 'email', 'password', 'firstName', 'lastName', 'level', 'security', 'active'];

    /**
     * The attributes that should be hidden for serialization.
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
    ];    

    public function hasBlocks()
    {
        return false;
    }

    public static function canAddBlocks()
    {
        return false;
    }

    public static function showBlockActions()
    {
        return false;
    }

    public static function canMoveBlocks()
    {
        return false;
    }

    /**
     * becasue Admin does not inherit from the base Model, it uses the base Model trait
     * any function overrides cannot call the parent::function, they must be fully functional duplicates
     * in the App it does inherit from here so they can use parent::
     */
    public function getFieldRequired($field_name)
    {
        // password is required if create no id number
        if (empty($this->id) && $field_name=='password') {
            return 'required';
        }

        if(in_array($field_name, ['level','security','slug', 'password', 'active', 'created_at', 'updated_at', 'related']))
            return '';
        if(in_array(self::getFieldType($field_name), ['check-box', 'check', 'switch', 'file-options', 'files-options', 'choose-parents']))
            return '';

        if(Str::startsWith($field_name, ['seo_']))
            return '';

        return 'required';
    }

    //no front end routes
    public static function getFrontEndRoute($default, $is_index=false) : String | null
    {
        return null;
    }

}